
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Department labels
departments = [
    "Sales",
    "Marketing",
    "HR",
    "Finance",
    "IT",
    "Customer Service",
    "Logistics",
    "R&D",
    "Production",
    "Admin"
]

# Communication metrics (average response time in minutes)
response_times = [15, 20, 35, 45, 30, 25, 40, 50, 55, 60]

# Labels and Titles
xlabel = "Average Response Time (minutes)"
ylabel = "Department"
title = "Average Response Time by Department"
supertitle = "Communication Efficiency Analysis"
annotation_text = "Note: Data is simulated for representation"
legendlabels = ["Department Response Times"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create horizontal bar chart
plt.figure(figsize=(10, 8))  # Adjust figure size
# Colors and Styles
bar_color = "dodgerblue"
edge_color = "navy"
text_color = "darkblue"

bars = plt.barh(departments, response_times, color=bar_color, edgecolor=edge_color)

# Adding data labels
for bar in bars:
    plt.text(
        bar.get_width() + 1,  # Offset slightly to the right of the bar
        bar.get_y() + bar.get_height() / 2,  # Centered vertically on the bar
        f"{bar.get_width()} min",  # Format label
        va="center", 
        color=text_color
    )

# Set labels and title
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)
plt.suptitle(supertitle)
plt.annotate(annotation_text, (0, 0), (0, -40), xycoords='axes fraction', textcoords='offset points', va='top')

# Removing unnecessary spines for a cleaner look
plt.gca().spines["top"].set_visible(False)
plt.gca().spines["right"].set_visible(False)
plt.gca().spines["bottom"].set_visible(False)
plt.gca().spines["left"].set_visible(False)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_243.pdf", bbox_inches="tight")
