

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Transportation mode labels
modes_of_transportation = [
    "Car",
    "Bus",
    "Bicycle",
    "Walking",
    "Train",
    "Motorbike",
    "Scooter",
    "Tram",
    "Boat",
    "Airplane",
]

# Approximate usage values
usage_percentage = [40.0, 20.0, 10.0, 8.0, 7.0, 5.0, 3.0, 2.0, 1.0, 4.0]
xlabel = "Usage Percentage (%)"
ylabel = "Modes of Transportation"
title = "Usage of Different Modes of Transportation"
super_title = "Transportation Trends in 2023"
annotation_text = "Source: Transportation Data 2023"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create horizontal bar chart
plt.figure(figsize=(10, 8))  # Adjust figure size
plt.barh(modes_of_transportation, usage_percentage, color="skyblue", edgecolor="darkblue")

# Adding data labels
for index, value in enumerate(usage_percentage):
    plt.text(value, index, f" {value}%", va="center", fontsize=10, color="darkblue", fontweight='bold')

# Set labels, title, and supertitle
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title, fontsize=14, fontweight='bold')
plt.suptitle(super_title, fontsize=16, fontweight='bold')
plt.annotate(annotation_text, xy=(0.5, -0.1), xycoords='axes fraction', ha='center', fontsize=10, color="grey")

# Style adjustments
plt.gca().spines["top"].set_visible(False)
plt.gca().spines["right"].set_visible(False)
plt.gca().spines["bottom"].set_visible(False)
plt.gca().spines["left"].set_visible(False)
plt.gca().xaxis.set_ticks_position('none') 
plt.gca().yaxis.set_ticks_position('none') 

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout(rect=[0, 0, 1, 0.95])
plt.savefig("bar_244.pdf", bbox_inches="tight")

