
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.colors as mcolors
import matplotlib.ticker as ticker

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
genres = [
    "Action",
    "Adventure",
    "Role-Playing",
    "Simulation",
    "Strategy",
    "Sports",
]
number_of_games = [1200, 850, 900, 450, 300, 600]

# Plot Configuration
xlabel = "Number of Games"
xlim_values = (0, 1300)
ylim_values = (-0.5, 5.5)
title_text = "Number of Games by Genre"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
yticks_rotation = 45
colors = [
    "lightsteelblue",
    "mediumseagreen",
    "lightblue",
    "mediumaquamarine",
    "paleturquoise",
    "lightcyan",
]
# Create horizontal bar chart
plt.figure(figsize=(12, 8))
plt.barh(
    genres, number_of_games, color=colors, edgecolor="gray"
)
plt.xlabel(xlabel)
plt.xlim(*xlim_values)
plt.ylim(*ylim_values)
plt.title(title_text)

basetick = [0, 1, 2, 3, 4, 5]
offsetticks = [-0.5, 0.5, 1.5, 2.5, 3.5, 4.5, 5.5]
plt.gca().yaxis.set_major_locator(ticker.FixedLocator(basetick))
plt.gca().yaxis.set_major_formatter(
    ticker.FuncFormatter(lambda x, _: f"{genres[x-1]}")
)
plt.gca().yaxis.set_minor_locator(ticker.FixedLocator(offsetticks))
plt.gca().grid(True, which="minor", axis="y", color="gray", linestyle="--")
plt.gca().grid(True, which="major", axis="x", color="gray", linestyle="--")
plt.gca().set_axisbelow(True)
plt.tick_params(axis="both", which="major", length=0)
plt.tick_params(axis="y", which="minor", color="gray", length=3)
plt.gca().spines["top"].set_visible(False)
plt.gca().spines["right"].set_visible(False)
plt.gca().spines["bottom"].set_visible(False)
plt.gca().spines["left"].set_visible(False)
plt.yticks(rotation=yticks_rotation)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_248.pdf", bbox_inches="tight")
