
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Sports Data Example
categories = [
    "Win Rate",
    "Fan Engagement",
    "Revenue Growth",
    "Sponsor Deals",
    "Player Performance",
    "Youth Development",
    "Brand Value",
][::-1]
us_data = [85, 78, 84, 90, 76, 88, 82][::-1]
eu_data = [80, 75, 82, 86, 70, 85, 78][::-1]
china_data = [88, 82, 90, 95, 83, 91, 86][::-1]
india_data = [88, 79, 85, 88, 78, 86, 81][::-1]
brazil_data = [75, 68, 73, 80, 65, 77, 70][::-1]
labels = ["US", "EU", "China", "India", "Brazil"]

xlabel = "Performance Metrics"
ylabel = "Metrics"
title = "Sports Industry Performance Metrics"
legendlabels = ["US", "EU", "China", "India", "Brazil"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(8, 5))
bar_width = 0.5
y_pos = range(len(categories))

# Custom color scheme
colors = ["#FF5733", "#FFC300", "#DAF7A6", "#C70039", "#900C3F"]

ax.barh(y_pos, us_data, bar_width, color=colors[0], label=labels[0])
ax.barh(y_pos, eu_data, bar_width, left=us_data, color=colors[1], label=labels[1])
ax.barh(
    y_pos,
    china_data,
    bar_width,
    left=[i + j for i, j in zip(us_data, eu_data)],
    color=colors[2],
    label=labels[2],
)
ax.barh(
    y_pos,
    india_data,
    bar_width,
    left=[i + j + k for i, j, k in zip(us_data, eu_data, china_data)],
    color=colors[3],
    label=labels[3],
)
ax.barh(
    y_pos,
    brazil_data,
    bar_width,
    left=[
        i + j + k + l for i, j, k, l in zip(us_data, eu_data, china_data, india_data)
    ],
    color=colors[4],
    label=labels[4],
)

# Labels and Legend
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)
ax.set_xticks(np.arange(0, 301, 50))
ax.set_yticks(y_pos)
ax.grid(axis="x", color="gray", linestyle="--", linewidth=0.5)
ax.set_axisbelow(True)
ax.set_yticklabels(categories)
ax.legend(loc="upper center", bbox_to_anchor=(0.5, 1.2), ncols=3)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_249.pdf", bbox_inches="tight")
