
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data for the plots (Average annual increase in renewable energy production)
countries = ["Country A", "Country B", "Country C", "Country D", "Country E"]
energy_growth = [5.3, -2.2, 8.1, -1.5, 3.8]

# Axes Limits and Labels
chart_title = "Annual Growth in Renewable Energy Production"
xticks_range = range(-5, 11, 2)
x_axis_label = "Annual Growth (%)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size to match the original image's dimensions
fig, ax = plt.subplots(figsize=(10, 8))

# Plot for Energy Growth
colors = ['#1f77b4', '#ff7f0e', '#2ca02c', '#d62728', '#9467bd']
hatches = ['', '\\\\', '', '\\\\', '']
bars = ax.barh(countries, energy_growth, color=colors, edgecolor="black")

for bar, value, hatch in zip(bars, energy_growth, hatches):
    if value < 0:
        bar.set_hatch(hatch)
        bar.set_edgecolor("red")
ax.set_title(chart_title, fontsize=16)
for i, v in enumerate(energy_growth):
    ax.text(
        v - 0.5 if v < 0 else v + 0.5,
        i,
        f"{v}%",
        color="black" if v > 0 else "red",
        va="center",
        ha="right" if v < 0 else "left",
        fontsize=12
    )

# Add a vertical line at x=0
ax.axvline(0, color="black", linewidth=0.8)
ax.set_xticks(xticks_range)
# Remove y-axis tick marks
ax.tick_params(axis="y", which="both", left=False)

# Hide all axes except the bottom one
for spine in ["left", "right", "top"]:
    ax.spines[spine].set_visible(False)

# Add x-axis label
ax.set_xlabel(x_axis_label, fontsize=14)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_260.pdf", bbox_inches="tight")
