
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.colors as mcolors

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data
categories = [
    "recycling",
    "renewable energy",
    "water conservation",
    "land restoration",
    "wildlife protection",
    "sustainable farming",
    "public awareness",
]
synthetic_data = [
    -15,
    -20,
    -10,
    -18,
    -22,
    -14,
    -16,
]
human_data = [25, 30, 15, 28, 35, 20, 22]

# Labels
labels = ["synthetic effort", "human effort"]
xlabel = "Effort Allocation (%)"
ylabel = "Environmental Activities"
title = "Effort Allocation in Environmental Activities"
legend_labels = ["Synthetic Effort", "Human Effort"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
fig, ax = plt.subplots(figsize=(8, 6))  # Adjusting figure size for better readability

# Define new colors
base_colors = [
    "#1A936F",
    "#114B5F",
    "#88D498",
    "#C6DABF",
    "#4E598C",
    "#F3E9D2",
    "#F26D6D",
]

# Generate colors with different opacity
colors_human = base_colors
colors_synthetic = [mcolors.to_rgba(color, alpha=0.6) for color in base_colors]

# Plot horizontal bar chart
ax.barh(categories, synthetic_data, color=colors_synthetic, label=labels[0])
ax.barh(categories, human_data, left=0, color=colors_human, label=labels[1])

# Add data labels inside the bars
for i, (syn_val, hum_val) in enumerate(zip(synthetic_data, human_data)):
    ax.text(syn_val / 2, i, f"{abs(syn_val)}%", va="center", ha="center", color="white")
    ax.text(hum_val / 2, i, f"{hum_val}%", va="center", ha="center", color="white")

# Remove y-axis tick marks
ax.tick_params(axis="y", which="both", left=False)

# Set x-axis limits
ax.set_xlim(min(synthetic_data) - 10, max(human_data) + 10)
ax.set_xticks(np.arange(min(synthetic_data), max(human_data) + 1, 5))
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)

# Adding gridlines for better readability
ax.grid(True, which='both', linestyle='--', linewidth=0.5, color='gray', alpha=0.7)

# Hide left and right spines
ax.spines["left"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.spines["top"].set_visible(False)

# Draw a vertical line at x=0
ax.axvline(0, color="black", linewidth=1)

# Adding legend
ax.legend(legend_labels, loc='upper right')

# Invert y-axis for better readability
ax.invert_yaxis()

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()

# Save the figure
plt.savefig("bar_266.pdf", bbox_inches="tight")
