
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data related to different legal specializations
categories = [
    "Criminal Law",
    "Corporate Law",
    "Family Law",
    "Intellectual Property Law",
    "Environmental Law",
]
scores_0 = [0.65, 0.75, 0.60, 0.55, 0.70]
scores_20 = [0.68, 0.80, 0.62, 0.60, 0.75]
scores_40 = [0.70, 0.83, 0.63, 0.65, 0.77]
scores_60 = [0.72, 0.85, 0.65, 0.70, 0.80]
labels = ["Time 0", "Time 20", "Time 40", "Time 60"]
xlabel = "Popularity Scores"
ylabel = "Legal Specializations"
title = "Popularity of Legal Specializations Over Time"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Size of the plot
plt.figure(figsize=(12, 8))

# Adjust the position of the bars on the x-axis to prevent overlap
bar_height = 0.15
ind = [i * (bar_height * len(categories)) for i in range(len(scores_0))]

# Creating the bar plot with adjusted positions to prevent overlap
plt.barh(
    [pos + bar_height * 0 for pos in ind],
    scores_0,
    color="#1f78b4",  # Blue
    height=bar_height,
    label=labels[0],
)
plt.barh(
    [pos + bar_height * 1 for pos in ind],
    scores_20,
    color="#33a02c",  # Green
    height=bar_height,
    label=labels[1],
)
plt.barh(
    [pos + bar_height * 2 for pos in ind],
    scores_40,
    color="#e31a1c",  # Red
    height=bar_height,
    label=labels[2],
)
plt.barh(
    [pos + bar_height * 3 for pos in ind],
    scores_60,
    color="#ff7f00",  # Orange
    height=bar_height,
    label=labels[3],
)

# X and Y axis Labels
plt.xlabel(xlabel)
plt.ylabel(ylabel)

# Title of the plot
plt.title(title)

# Adding legend
plt.legend()

# Setting the labels for y-axis with adjusted positions
plt.yticks([pos + bar_height * 1.5 for pos in ind], categories)

# ===================
# Part 4: Saving Output
# ===================
# Display the plot with enough space
plt.tight_layout()

plt.savefig("bar_267.pdf", bbox_inches="tight")
