
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# New Sample data for illustrating air quality improvement over time
categories = [
    "Station A",
    "Station B",
    "Station C",
    "Station D",
    "Station E",
]
scores_2020 = [150, 160, 140, 170, 180]
scores_2025 = [130, 140, 120, 150, 160]
scores_2030 = [110, 120, 100, 130, 140]
scores_2035 = [90, 100, 80, 110, 120]
labels = ["Year 2020", "Year 2025", "Year 2030", "Year 2035"]
xlabel = "Air Quality Index (AQI)"
ylabel = "Monitoring Stations"
title = "Improvement in Air Quality Index Over Time"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Size of the plot
plt.figure(figsize=(10, 8))

# Adjust the position of the bars on the x-axis to prevent overlap
bar_height = 0.15
ind = [i * (bar_height * len(categories)) for i in range(len(scores_2020))]

# Creating the bar plot with adjusted positions to prevent overlap
plt.barh(
    [pos + bar_height * 0 for pos in ind],
    scores_2020,
    color="#2E8B57",  # SeaGreen
    height=bar_height,
    label=labels[0],
)
plt.barh(
    [pos + bar_height * 1 for pos in ind],
    scores_2025,
    color="#3CB371",  # MediumSeaGreen
    height=bar_height,
    label=labels[1],
)
plt.barh(
    [pos + bar_height * 2 for pos in ind],
    scores_2030,
    color="#66CDAA",  # MediumAquamarine
    height=bar_height,
    label=labels[2],
)
plt.barh(
    [pos + bar_height * 3 for pos in ind],
    scores_2035,
    color="#8FBC8B",  # DarkSeaGreen
    height=bar_height,
    label=labels[3],
)

# X and Y axis Labels
plt.xlabel(xlabel)
plt.ylabel(ylabel)

# Title of the plot
plt.title(title)

# Adding legend
plt.legend()

# Adding a grid for better readability
plt.grid(axis='x', linestyle='--', alpha=0.7)

# Setting the labels for y-axis with adjusted positions
plt.yticks([pos + bar_height * 1.5 for pos in ind], categories)

# ===================
# Part 4: Saving Output
# ===================
# Display the plot with enough space
plt.tight_layout()

plt.savefig("bar_268.pdf", bbox_inches="tight")
