

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Sample data for quarterly revenue in different companies (in billion dollars)
companies = [
    "Apple",
    "Microsoft",
    "Amazon",
    "Google",
    "Facebook",
]
revenue_q1 = [58.3, 35.0, 75.5, 40.0, 17.7]
revenue_q2 = [63.4, 36.9, 81.2, 41.2, 18.5]
revenue_q3 = [64.7, 38.0, 87.4, 43.5, 19.4]
revenue_q4 = [68.9, 40.2, 89.4, 45.1, 20.1]
labels = ["Q1", "Q2", "Q3", "Q4"]
xlabel = "Revenue (Billion $)"
ylabel = "Companies"
title = "Quarterly Revenue of Various Companies in 2022"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Size of the plot
plt.figure(figsize=(10, 8))

# Adjust the position of the bars on the x-axis to prevent overlap
bar_height = 0.15
ind = [i * (bar_height * len(companies)) for i in range(len(revenue_q1))]

# Color palette for revenues
colors = ["#FF6347", "#FFA07A", "#FFD700", "#ADFF2F"]

# Creating the bar plot with adjusted positions to prevent overlap
plt.barh(
    [pos + bar_height * 0 for pos in ind],
    revenue_q1,
    color=colors[0],
    height=bar_height,
    label=labels[0],
    edgecolor='black'
)
plt.barh(
    [pos + bar_height * 1 for pos in ind],
    revenue_q2,
    color=colors[1],
    height=bar_height,
    label=labels[1],
    edgecolor='black'
)
plt.barh(
    [pos + bar_height * 2 for pos in ind],
    revenue_q3,
    color=colors[2],
    height=bar_height,
    label=labels[2],
    edgecolor='black'
)
plt.barh(
    [pos + bar_height * 3 for pos in ind],
    revenue_q4,
    color=colors[3],
    height=bar_height,
    label=labels[3],
    edgecolor='black'
)

# X and Y axis Labels
plt.xlabel(xlabel, fontsize=12, fontweight='bold')
plt.ylabel(ylabel, fontsize=12, fontweight='bold')

# Title of the plot
plt.title(title, fontsize=14, fontweight='bold')

# Adding legend
plt.legend()

# Setting the labels for y-axis with adjusted positions
plt.yticks([pos + bar_height * 1.5 for pos in ind], companies)

# Adding grid for better readability
plt.grid(axis='x', linestyle='--', linewidth=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Display the plot with enough space
plt.tight_layout()
plt.savefig("bar_269.pdf", bbox_inches="tight")

