

# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Tourism data for different metrics across seasons
seasons = ["Winter", "Spring", "Summer", "Fall"]
Tourist_Arrivals = np.array([300, 500, 800, 400]) + np.random.rand(4) * 50  # Tourist Arrivals in Thousands
Hotel_Occupancy = np.array([60, 75, 90, 65]) + np.random.rand(4) * 5  # Hotel Occupancy Rate in Percentage
Avg_Spending = np.array([150, 200, 250, 180]) + np.random.rand(4) * 20  # Average Spending per Tourist in $
Local_Attractions = np.array([70, 95, 120, 85]) + np.random.rand(4) * 10  # Local Attractions Visits in Thousands

labels = ["Tourist Arrivals (Thousands)", "Hotel Occupancy Rate (%)", "Avg Spending per Tourist ($)", "Local Attractions Visits (Thousands)"]
xlabel = "Values"
ylabel = "Seasons"
title = "Tourism Metrics by Season"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Size of the plot
plt.figure(figsize=(10, 7))

# Adjust the position of the bars on the x-axis to prevent overlap
bar_height = 0.3
indices = np.arange(len(Tourist_Arrivals)) * 1.5  # Increase space between groups

# Define some hatch patterns and colors to use for bars
hatch_patterns = ["/", "\\", "|", "-", "+", "*"]
colors = ["#4CAF50", "#2196F3", "#F44336", "#9C27B0"]

# Plot bars for each tourism metric
for i, level in enumerate([Tourist_Arrivals, Hotel_Occupancy, Avg_Spending, Local_Attractions]):
    bars = plt.barh(
        [pos + bar_height * i for pos in indices],
        level,
        color=colors[i],
        height=bar_height,
        hatch=hatch_patterns[i],
        label=f"{labels[i]}",
    )

    # Add text annotations to the right of the bars
    for bar in bars:
        plt.text(
            bar.get_width(),  # X position
            bar.get_y() + bar.get_height() / 2,  # Y position
            f"{bar.get_width():.2f}",  # Text to display
            va="center",
        )

# X and Y axis Labels and limits
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.xlim(
    0,
    max(np.max(Tourist_Arrivals), np.max(Hotel_Occupancy), np.max(Avg_Spending), np.max(Local_Attractions))
    + 50,
)

# Title of the plot
plt.title(title)

# Adding legend
plt.legend()

# Setting the labels for y-axis with adjusted positions
plt.yticks([pos + bar_height * 1.5 for pos in indices], seasons)

# Adding grids
plt.grid(True, linestyle="--", which="both", axis="x", color="grey", alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Display the plot with enough space
plt.tight_layout()

# Save the plot as a PDF file
plt.savefig("bar_270.pdf", bbox_inches="tight")

