
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Define the categories and scores
categories = ["Mathematics", "Science", "History", "Literature"]
num_scores = 4
score_range = (-60, -80)
scores_math = np.random.uniform(score_range[0], score_range[1], num_scores).tolist()
scores_science = np.random.uniform(score_range[0], score_range[1], num_scores).tolist()
scores_history = np.random.uniform(score_range[0], score_range[1], num_scores).tolist()
scores_lit = np.random.uniform(score_range[0], score_range[1], num_scores).tolist()

# The x locations for the groups
ind = np.arange(len(scores_math))

# Labels and Plot Types
label_math = "Mathematics"
label_science = "Science"
label_history = "History"
label_lit = "Literature"

# Axes Limits and Labels
xlabel_value = "Average Test Score"
ax_title = "Subject-wise Average Test Scores"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# The width of the bars
bar_width = 0.2

# Create the figure and axes objects
fig, ax = plt.subplots(figsize=(10, 6))

# Custom color palette
colors = ['#6baed6', '#74c476', '#e377c2', '#ff7f0e']

# Plotting data
bars_math = ax.barh(
    ind - bar_width * 1.5,
    scores_math,
    bar_width,
    label=label_math,
    color=colors[0],
)
bars_science = ax.barh(
    ind - bar_width * 0.5,
    scores_science,
    bar_width,
    label=label_science,
    color=colors[1],
)
bars_history = ax.barh(
    ind + bar_width * 0.5,
    scores_history,
    bar_width,
    label=label_history,
    color=colors[2],
)
bars_lit = ax.barh(
    ind + bar_width * 1.5,
    scores_lit,
    bar_width,
    label=label_lit,
    color=colors[3],
)

# Adding text inside the bars
for i, (score_math, score_science, score_history, score_lit) in enumerate(
    zip(scores_math, scores_science, scores_history, scores_lit)
):
    ax.text(
        score_math - 0.5,
        i - bar_width * 1.5,
        f"{score_math:.1f}",
        va="center",
        ha="right",
        color="black",
    )
    ax.text(
        score_science - 0.5,
        i - bar_width * 0.5,
        f"{score_science:.1f}",
        va="center",
        ha="right",
        color="black",
    )
    ax.text(
        score_history - 0.5,
        i + bar_width * 0.5,
        f"{score_history:.1f}",
        va="center",
        ha="right",
        color="black",
    )
    ax.text(
        score_lit - 0.5,
        i + bar_width * 1.5,
        f"{score_lit:.1f}",
        va="center",
        ha="right",
        color="black",
    )

# Adding labels, title, and custom x-axis tick labels, etc.
ax.set_xlabel(xlabel_value)
ax.set_title(ax_title)
ax.set_xlim(min(scores_math) - 20, max(scores_lit) + 20)
ax.set_yticks(ind)
ax.set_yticklabels(categories)
ax.legend()

# Invert y-axis to have the first entry at the top
plt.gca().invert_yaxis()

# Show grid lines for x-axis
ax.xaxis.grid(True)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_274.pdf", bbox_inches="tight")
