
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(2)
# Define the categories and scores
categories = ["Social Media", "Traditional Media", "Streaming Services", "Gaming"]
num_scores = 4
score_range = (-100, 0)
scores_user_engagement = np.random.uniform(score_range[0], score_range[1], num_scores).tolist()
scores_audience_trust = np.random.uniform(score_range[0], score_range[1], num_scores).tolist()
scores_tech_advancement = np.random.uniform(score_range[0], score_range[1], num_scores).tolist()
scores_creativity = np.random.uniform(score_range[0], score_range[1], num_scores).tolist()

# The x locations for the groups
ind = np.arange(len(scores_user_engagement))

# Labels and Plot Types
label_user_engagement = "User Engagement"
label_audience_trust = "Audience Trust"
label_tech_advancement = "Technological Advancements"
label_creativity = "Creative Content"

# Axes Limits and Labels
xlabel_value = "Impact Score"
ax_title = "Impact Levels by Media Sector and Initiative"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# The width of the bars
bar_width = 0.2

# Create the figure and axes objects
fig, ax = plt.subplots(figsize=(12, 8))

# Plotting data
bars_user_engagement = ax.barh(
    ind - bar_width * 1.5,
    scores_user_engagement,
    bar_width,
    label=label_user_engagement,
    color="#ff9999",   # Light Red
)
bars_audience_trust = ax.barh(
    ind - bar_width * 0.5,
    scores_audience_trust,
    bar_width,
    label=label_audience_trust,
    color="#66b3ff",   # Light Blue
)
bars_tech_advancement = ax.barh(
    ind + bar_width * 0.5,
    scores_tech_advancement,
    bar_width,
    label=label_tech_advancement,
    color="#99ff99",   # Light Green
)
bars_creativity = ax.barh(
    ind + bar_width * 1.5,
    scores_creativity,
    bar_width,
    label=label_creativity,
    color="#ffcc99",   # Light Orange
)

# Adding text inside the bars
for i, (score_eng, score_trust, score_tech, score_creative) in enumerate(
    zip(scores_user_engagement, scores_audience_trust, scores_tech_advancement, scores_creativity)
):
    ax.text(
        score_eng,
        i - bar_width * 1.5,
        f"{score_eng:.1f}",
        va="center",
        ha="right",
        color="black",
    )
    ax.text(
        score_trust,
        i - bar_width * 0.5,
        f"{score_trust:.1f}",
        va="center",
        ha="right",
        color="black",
    )
    ax.text(
        score_tech,
        i + bar_width * 0.5,
        f"{score_tech:.1f}",
        va="center",
        ha="right",
        color="black",
    )
    ax.text(
        score_creative,
        i + bar_width * 1.5,
        f"{score_creative:.1f}",
        va="center",
        ha="right",
        color="black",
    )

# Adding labels, title, and custom x-axis tick labels, etc.
ax.set_xlabel(xlabel_value)
ax.set_title(ax_title)
ax.set_yticks(ind)
ax.set_yticklabels(categories)
ax.legend()

# Invert y-axis to have the first entry at the top
plt.gca().invert_yaxis()

# Show grid lines for x-axis
ax.xaxis.grid(True)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_275.pdf", bbox_inches="tight")
