
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Example societal data
categories = [
    "Healthcare",
    "Education",
    "Infrastructure",
    "Economy",
]
layer_data = {
    "Funding": np.array([800, 750, 600, 700]),
    "Quality": np.array([600, 680, 700, 650]),
    "Accessibility": np.array([700, 600, 550, 620]),
    "Satisfaction": np.array([750, 700, 650, 800]),
}

title = "Stacked Bar Chart of Societal Aspects"
xlabel = "Societal Aspects"
ylabel = "Values"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================

# Colors for each layer (earth-toned palette)
colors = ["#4c9f70", "#88c999", "#d9f2d4", "#116611"]

# Create the figure and axes objects
fig, ax = plt.subplots(figsize=(10, 6))

# Variables to store the bottom position for each stack
bottoms = np.array([0] * len(categories))

for i, (layer, values) in enumerate(layer_data.items()):
    bars = ax.bar(categories, values, bottom=bottoms, color=colors[i], label=layer)

    # Add data labels on each bar
    for bar, bottom in zip(bars, bottoms):
        height = bar.get_height()
        ax.text(
            bar.get_x() + bar.get_width() / 2,
            bottom + height / 2,
            str(height),
            ha="center",
            va="center",
            color="white",
        )

    # Update the bottoms position
    bottoms += values

# Chart title and labels
plt.title(title)
plt.xlabel(xlabel)
plt.ylabel(ylabel)

# Adding gridlines for better readability
ax.yaxis.grid(True)

# Adding legend
plt.legend()

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
# Save the plot as PDF
plt.savefig("bar_284.pdf", bbox_inches="tight")
