

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Sample data
cities = ["New York", "Paris", "Tokyo", "Sydney", "Cairo", "Rio"]
tourist_counts = {
    "New York": [9, 10, 12, 8, 11],
    "Paris": [12, 15, 11, 14, 13],
    "Tokyo": [8, 12, 15, 10, 11],
    "Sydney": [10, 11, 14, 9, 12],
    "Cairo": [7, 6, 9, 8, 10],
    "Rio": [11, 10, 12, 13, 14],
}

title = "Tourist Attraction Visits in Different Cities"
xlabel = "City"
ylabel = "Number of Visitors (in millions)"
ylim = [0, 70]
yticks = range(0, 71, 10)
tourist_labels = [f"Attraction {i+1}" for i in range(5)]
legendtitle = "Tourist Attractions"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Define a color map for gradients
cmap = plt.get_cmap("viridis")

fig, ax = plt.subplots(figsize=(10, 6))  # Adjusting figure size

for i, city in enumerate(cities):
    bottom = 0
    count_list = tourist_counts[city]
    for j, count in enumerate(count_list):
        color = cmap(
            1 - j / len(count_list)
        )  # Determine color based on position in list
        bar = ax.bar(city, count, bottom=bottom, color=color)
        bottom += count
        # Annotate each segment
        if j == len(count_list) - 1:
            ax.text(
                bar[0].get_x() + bar[0].get_width() / 2,
                bottom - count / 2,
                str(count),
                ha="center",
                va="bottom",
                color="black",
            )
        else:
            ax.text(
                bar[0].get_x() + bar[0].get_width() / 2,
                bottom - count / 2,
                str(count),
                ha="center",
                va="center",
                color="white",
            )

# Adding title and labels
ax.set_title(title)
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_ylim(ylim)  # Adjusting limit to make space for text annotations
ax.set_yticks(yticks)

# Adding legend with score indications
ax.legend(tourist_labels, title=legendtitle, bbox_to_anchor=(1.05, 1), loc="upper left")
ax.yaxis.grid(linestyle="--")

ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_290.pdf", bbox_inches="tight")

