
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data
import numpy as np

np.random.seed(42)  # Setting a different seed for new data

categories = ["Ancient", "Medieval", "Renaissance", "Modern", "Industrial", "Contemporary", "Post-War"]
# Generate three lists
Discovery, Influence, Legacy = np.random.dirichlet(np.ones(3), size=len(categories)).T

Discovery = Discovery * 100
Influence = Influence * 100
Legacy = Legacy * 100

labels = ["Discovery", "Influence", "Legacy"]
yticks = np.arange(0, 101, 20)
ylim = [0, 100]

# Text labels
xlabel = "Historical Periods"
ylabel = "Historical Impact Parameters (%)"
title = "Historical Impact Analysis"
legendlabels = ["Discovery", "Influence", "Legacy"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Stacked bar chart setup
bar_width = 0.9
r = np.arange(len(categories))

# Plot
fig, ax = plt.subplots(figsize=(10, 6))
bar1 = ax.bar(
    r,
    Discovery,
    color="#c0a9cf",
    edgecolor="white",
    hatch="//",
    width=bar_width,
    label=labels[0],
)
bar2 = ax.bar(
    r,
    Influence,
    bottom=Discovery,
    color="#98c1d9",
    edgecolor="white",
    hatch="xx",
    width=bar_width,
    label=labels[1],
)
bar3 = ax.bar(
    r,
    Legacy,
    bottom=Discovery + Influence,
    color="#66c2a5",
    edgecolor="white",
    hatch="..",
    width=bar_width,
    label=labels[2],
)

ax.set_xticks(r)
ax.set_xticklabels(categories, rotation=-45, ha="left")
ax.set_yticks(yticks)
ax.set_ylim(ylim)
ax.set_yticklabels(["{}%".format(i) for i in range(0, 101, 20)])
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)
ax.legend(loc="upper center", bbox_to_anchor=(0.5, 1.15), ncol=3)

ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.spines["left"].set_visible(False)
ax.spines["bottom"].set_visible(False)
# Grid lines
ax.yaxis.grid(True, linestyle="--", color="gray", alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("bar_292.pdf", bbox_inches="tight")

