
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data
import numpy as np

np.random.seed(0)

# New regions for the economics domain
regions = ["East", "West", "North", "South", "Central"]

# Generate three lists
UnemploymentRate, InflationRate, InterestRate = np.random.dirichlet(np.ones(3), size=len(regions)).T

UnemploymentRate = UnemploymentRate * 100
InflationRate = InflationRate * 100
InterestRate = InterestRate * 100

# Labels and other text-related parameters
labels = ["Unemployment Rate", "Inflation Rate", "Interest Rate"]
yticks = np.arange(0, 101, 20)
ylim = [0, 100]
xlabel = "Regions"
ylabel = "Percentage"
title = "Economic Metrics by Region"

legend_loc = "upper center"
legend_bbox_to_anchor = (0.5, 1.15)
legend_ncol = 3

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Stacked bar chart setup
bar_width = 0.9
r = np.arange(len(regions))

# Plot
fig, ax = plt.subplots(figsize=(10, 6))
bar1 = ax.bar(
    r,
    UnemploymentRate,
    color="#89c1a8",
    edgecolor="white",
    hatch="++",
    width=bar_width,
    label=labels[0],
)
bar2 = ax.bar(
    r,
    InflationRate,
    bottom=UnemploymentRate,
    color="#ffb75d",
    edgecolor="white",
    hatch="--",
    width=bar_width,
    label=labels[1],
)
bar3 = ax.bar(
    r,
    InterestRate,
    bottom=UnemploymentRate + InflationRate,
    color="#5ba3ff",
    edgecolor="white",
    hatch="\\\\\\",
    width=bar_width,
    label=labels[2],
)

ax.set_xticks(r)
ax.set_xticklabels(regions, rotation=0, ha="center")
ax.set_yticks(yticks)
ax.set_ylim(ylim)
ax.set_yticklabels(["{}%".format(i) for i in range(0, 101, 20)])
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)
ax.legend(loc=legend_loc, bbox_to_anchor=legend_bbox_to_anchor, ncol=legend_ncol)

ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.spines["left"].set_visible(False)
ax.spines["bottom"].set_visible(False)
# Grid lines
ax.yaxis.grid(True, linestyle="--", color="gray")

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("bar_293.pdf", bbox_inches="tight")
