

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(2)

# Data
products = ["Product 1", "Product 2", "Product 3", "Product 4", "Product 5"]
sales_improvements = {"North America": [3.2], "Europe": [4.0], "Asia": [6.3], "Australia": [3.8], "South America": [4.5]}

xlabel = "Product"
ylabel = "Sales Increase [%]"
ylim = [0, 7]
legendtitle = "Region"
title = "Sales Improvement by Region"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Colors for each region
colors = ["#ff9999", "#66b3ff", "#99ff99", "#ffcc99", "#c2c2f0"]

# Figure and axis
fig, ax = plt.subplots(figsize=(10, 6))

# Bar width
bar_width = 0.75

# Positions of the bars on the x-axis
r = np.arange(len(products))

# Plotting the bars
for i, region in enumerate(sales_improvements):
    bars = plt.bar(
        r[i],
        sales_improvements[region],
        color=colors[i],
        width=bar_width,
        label=region,
        hatch="\\",
        edgecolor="white",
    )
    # Add text labels
    for bar, val in zip(bars, sales_improvements[region]):
        height = bar.get_height()
        ax.text(
            bar.get_x() + bar.get_width() / 2,
            height + 0.1 if height > 0 else height - 0.4,
            f"{val:.1f}",
            ha="center",
        )

# Add xticks on the middle of the group bars
plt.xlabel(xlabel)
plt.xticks(r, products, rotation=45)

# Add ylabel
plt.ylabel(ylabel)
plt.ylim(ylim)

plt.gca().grid(color="gray", linewidth=0.5, linestyle='--')
plt.gca().set_axisbelow(True)

# Create legend & Show graphic
plt.legend(title=legendtitle, loc="upper left")
plt.title(title)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_294.pdf", bbox_inches="tight")

