
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(0)

# Data
majors = ["Computer Science", "Mathematics", "Physics", "Chemistry", "Biology"]
enrollment_increase = {"Computer Science": [3.2], "Mathematics": [2.8], "Physics": [2.2], "Chemistry": [1.9], "Biology": [2.5]}

xlabel = "College Major"
ylabel = "Enrollment Increase [%]"
ylim = [0, 4]
legendtitle = "College Major"
title = "Increase in Student Enrollment by Major"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Colors for each major
colors = ["#4c72b0", "#55a868", "#c44e52", "#8172b3", "#ccb974"]

# Figure and axis
fig, ax = plt.subplots(figsize=(10, 6))

# Bar width
bar_width = 0.75

# Positions of the bars on the x-axis
r = np.arange(len(majors))

# Plotting the bars
for i, major in enumerate(enrollment_increase):
    bars = plt.bar(
        r[i],
        enrollment_increase[major],
        color=colors[i],
        width=bar_width,
        label=major,
        hatch="//",
        edgecolor="white",
    )
    # Add text labels
    for bar, val in zip(bars, enrollment_increase[major]):
        height = bar.get_height()
        ax.text(
            bar.get_x() + bar.get_width() / 2,
            height + 0.1 if height > 0 else height - 0.4,
            f"{val:.1f}",
            ha="center",
        )

# Add xticks on the middle of the group bars
plt.xlabel(xlabel)
plt.xticks(r, majors, rotation=45)

# Add ylabel
plt.ylabel(ylabel)
plt.ylim(ylim)

plt.gca().grid(color="gray", linewidth=0.5)
plt.gca().set_axisbelow(True)

# Create legend & Show graphic
plt.legend(title=legendtitle, loc="upper right")
plt.title(title)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_295.pdf", bbox_inches="tight")
