
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Set a seed for reproducibility

# Define time periods (months)
months = np.array([1, 2, 3, 4, 5])

# Generate synthetic monthly active user (MAU) changes for two tech companies
mau_changes_company_a = np.random.uniform(-5, 15, 5)  # Example % change in MAU for Company A
mau_changes_company_b = np.random.uniform(-5, 15, 5)  # Example % change in MAU for Company B

# Labels and other textual content
labels = ["Company A", "Company B"]
axline = 0
xlabel = "Month"
ylabel = "MAU Change (%)"
title = "Monthly Active User (MAU) Growth in Tech Companies"
ylim = [-5, 15]
yticks = np.arange(-5, 16, 5)

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and subplots
fig, axs = plt.subplots(figsize=(10, 5))
width = 0.4

# Color scheme for the bars
colors = ['#ff9999','#66b3ff']

# Plotting bars for each company
bars1 = axs.bar(
    months - width / 2,
    mau_changes_company_a,
    width=width,
    color=colors[0],
    label="Company A",
)
bars2 = axs.bar(
    months + width / 2,
    mau_changes_company_b,
    width=width,
    color=colors[1],
    label="Company B",
)

# Adding text labels on the bars
for bars in [bars1, bars2]:
    for bar in bars:
        height = bar.get_height()
        axs.text(
            bar.get_x() + bar.get_width() / 2,
            height,
            f"{height:.1f}",
            ha="center",
            va="bottom" if height > 0 else "top",
        )

# Additional plot settings
axs.axhline(axline, color="black")
axs.set_xlabel(xlabel)
axs.set_ylabel(ylabel)
axs.set_title(title, fontsize=14)
axs.set_ylim(ylim)
axs.set_yticks(yticks)
axs.set_xticks(months)
axs.yaxis.grid(True)
axs.set_axisbelow(True)

# Adding legend and adjusting layout
plt.legend(loc="upper center", bbox_to_anchor=(0.5, 1.), ncol=2)

# ===================
# Part 4: Saving Output
# ===================
# Save the figure as a PDF
plt.tight_layout()
plt.savefig("bar_297.pdf", bbox_inches="tight")
