
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Set a seed for reproducibility

# Define months
months = np.array([1, 2, 3, 4, 5])

# Generate synthetic sales data for two stores
total_sales_store_a = np.random.normal(200, 50, 5)  # Example total sales for Store A in thousands
total_sales_store_b = np.random.normal(250, 60, 5)  # Example total sales for Store B in thousands

labels = ["Store A", "Store B"]
axline = 0
xlabel = "Months"
ylabel = "Total Sales (in $1000s)"
ylim = [0, 400]
yticks = np.arange(0, 450, 50)
title = "Monthly Sales Performance for Store A and Store B"
legend_labels = ["Store A", "Store B"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and subplots
fig, axs = plt.subplots(figsize=(10, 5))
width = 0.4

# Plotting bars for each store
bars1 = axs.bar(
    months - width / 2,
    total_sales_store_a,
    width=width,
    color="#1f77b4",  # Blue color for Store A
    edgecolor="black",
    label="Store A",
)
bars2 = axs.bar(
    months + width / 2,
    total_sales_store_b,
    width=width,
    color="#ff7f0e",  # Orange color for Store B
    edgecolor="black",
    label="Store B",
)

# Adding text labels on the bars
for bars in [bars1, bars2]:
    for bar in bars:
        height = bar.get_height()
        axs.text(
            bar.get_x() + bar.get_width() / 2,
            height,
            f"{height:.1f}",
            ha="center",
            va="bottom" if height > 0 else "top",
        )

# Additional plot settings
axs.axhline(axline, color="black")
axs.set_xlabel(xlabel, fontsize=14)
axs.set_ylabel(ylabel, fontsize=14)
axs.set_ylim(ylim)
axs.set_yticks(yticks)
axs.set_xticks(months)
axs.yaxis.grid(True)
axs.set_axisbelow(True)

# Adding title and legend
axs.set_title(title, fontsize=16)
plt.legend(loc="upper center", bbox_to_anchor=(0.5, 1.2), ncol=2, fontsize=12)

# ===================
# Part 4: Saving Output
# ===================
# Save the figure as a PDF
plt.tight_layout()
plt.savefig("bar_298.pdf", bbox_inches="tight")
