
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(32)
# Set a seed for reproducibility

# Define publication periods
periods = np.array([2018, 2019, 2020, 2021, 2022])

# Generate synthetic book sales changes for two literature genres
fiction_sales_changes = np.random.uniform(-15, 15, 5)  # Fiction
non_fiction_sales_changes = np.random.uniform(-15, 15, 5)  # Non-Fiction

# Chart text settings
labels = ["Fiction", "Non-Fiction"]
axline = 0
xlabel = "Publication Year"
ylabel = "Book Sales Change (%)"
ylim = [-15, 15]
yticks = np.arange(-15, 16, 5)
title = "Literature Sales Trends"
subtitle = "Changes in Book Sales Across Publication Years"
legend_labels = ["Fiction", "Non-Fiction"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and subplots
fig, axs = plt.subplots(figsize=(10, 5))
width = 0.4

# Plotting bars for each literature genre
bars1 = axs.bar(
    periods - width / 2,
    fiction_sales_changes,
    width=width,
    color="#8B4513",  # SaddleBrown for Fiction
    label=legend_labels[0],
)
bars2 = axs.bar(
    periods + width / 2,
    non_fiction_sales_changes,
    width=width,
    color="#A0522D",  # Sienna for Non-Fiction
    label=legend_labels[1],
)

# Adding text labels on the bars
for bars in [bars1, bars2]:
    for bar in bars:
        height = bar.get_height()
        axs.text(
            bar.get_x() + bar.get_width() / 2,
            height,
            f"{height:.1f}",
            ha="center",
            va="bottom" if height > 0 else "top",
        )

# Additional plot settings
axs.axhline(axline, color="black", linestyle='--', linewidth=0.8)
axs.set_xlabel(xlabel, fontsize=12)
axs.set_ylabel(ylabel, fontsize=12)
axs.set_ylim(ylim)
axs.set_yticks(yticks)
axs.set_xticks(periods)
axs.yaxis.grid(True, linestyle=':', linewidth=0.5)
axs.set_axisbelow(True)

# Adding titles and legend
axs.set_title(subtitle, fontsize=14, pad=20)
fig.suptitle(title, fontsize=16, fontweight='bold')
plt.legend(loc="upper center", bbox_to_anchor=(0.5, 1.10), ncol=2)

# ===================
# Part 4: Saving Output
# ===================
# Save the figure as a PDF
plt.tight_layout(rect=[0, 0, 1, 0.95])  # Adjust layout to make space for the titles
plt.savefig("bar_299.pdf", bbox_inches="tight")
