

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Setting seed for reproducibility
np.random.seed(42)

# Data
seasons = ["2019/20", "2020/21", "2021/22"]
# Artificial data for players' performance over three seasons
points = [25, 27, 30]
rebounds = [10, 12, 11]
assists = [8, 9, 10]
steals = [3, 2, 4]
blocks = [2, 3, 3]

points_minus = [-2, -1, -3]
rebounds_minus = [-1, -2, -1]
assists_minus = [-1, -1, -2]
steals_minus = [0, 0, -1]
blocks_minus = [0, -1, -1]

values = [points, rebounds, assists, steals, blocks]
values_minus = [points_minus, rebounds_minus, assists_minus, steals_minus, blocks_minus]
labels = ["Points", "Rebounds", "Assists", "Steals", "Blocks"]
xlabel = "Performance Metrics"
yticks = np.arange(-5, 36, 5)
ylabel = "Number of Events"
legendtitle = "Seasons"
title = "Basketball Players' Performance in Different Metrics"
subtitle = "Comparison across 2019/20, 2020/21, and 2021/22 Seasons"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Custom color scheme
colors = ["#FFA07A", "#20B2AA", "#778899"]

# Set up the figure size
plt.figure(figsize=(12, 6))

# Set up the bar width
barWidth = 0.15

# Set up positions for the bars
positions = np.arange(len(labels))

# Creating bars for each season
for i, season in enumerate(seasons):
    pos = [x + barWidth * i for x in positions]  # shift each bar by `barWidth * i`
    plt.bar(
        pos,
        [v[i] for v in values],
        color=colors[i],
        width=barWidth,
        edgecolor="grey",
        label=season,
    )
    plt.bar(
        pos,
        [v[i] for v in values_minus],
        color=colors[i],
        width=barWidth,
        edgecolor="grey",
        alpha=0.7,
    )

    # Add text on top and bottom of the bars
    for idx, val in enumerate(pos):
        plt.text(
            val,
            values[idx][i] - 1,
            f"{values[idx][i]}",
            ha="center",
            va="top",
            rotation=-90,
        )
        plt.text(
            val,
            values_minus[idx][i] + 1,
            f"{-values_minus[idx][i]}",
            ha="center",
            va="bottom",
            rotation=-90,
        )

# Adding titles, axis labels and ticks
plt.title(title, fontweight='bold')
plt.suptitle(subtitle, fontsize=10, fontstyle='italic')
plt.xlabel(xlabel)
plt.xticks([r + barWidth * 1.0 for r in range(len(labels))], labels)
plt.yticks(yticks)
plt.ylabel(ylabel)

# Add a legend and display the plot
plt.legend(title=legendtitle)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_300.pdf", bbox_inches="tight")

