
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data for the bar charts
genre_a_sales = [350, 420, 300, 280]
genre_b_sales = [280, 330, 310, 220]
x = np.arange(len(genre_a_sales))  # x-coordinates for the bars

# Labels and Titles
labels = ["Genre A Sales", "Genre B Sales"]
title = "Quarterly Book Sales for Genres A and B"
xlabel = "Quarters"
ylabel1 = "Genre A Sales (in thousands)"
ylabel2 = "Genre B Sales (in thousands)"
legend_labels = ["Genre A", "Genre B"]
season_labels = ["Q1", "Q2", "Q3", "Q4"]

# Plot configuration
ylim1 = [0, 500]  # y-axis limits for the first subplot
ylim2 = [0, 400]  # y-axis limits for the second subplot
yticks1 = [0, 100, 200, 300, 400, 500]  # y-ticks for the first subplot
yticks2 = [0, 100, 200, 300, 400]  # y-ticks for the second subplot

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size to match the original image's dimensions
fig, ax1 = plt.subplots(figsize=(8, 5))

# Colors
color_genre_a = "#1f77b4"
color_genre_b = "#ff7f0e"

# Create the first subplot for 'genre_a_sales' using the left y-axis
ax1.bar(
    x,
    genre_a_sales,
    width=0.4,
    label=legend_labels[0],
    color=color_genre_a,
    align="center",
)
ax1.set_ylabel(ylabel1, color=color_genre_a)
ax1.tick_params(axis="y", labelcolor=color_genre_a)

# Create the second y-axis for 'genre_b_sales'
ax2 = ax1.twinx()
ax2.bar(
    x + 0.4,
    genre_b_sales,
    width=0.4,
    label=legend_labels[1],
    color=color_genre_b,
    align="center",
)
ax2.set_ylabel(ylabel2, color=color_genre_b)
ax2.tick_params(axis="y", labelcolor=color_genre_b)

# Title and x-axis labels
ax1.set_title(title)
ax1.set_xlabel(xlabel)
ax1.set_xticks(x + 0.2)
ax1.set_xticklabels(season_labels)

# Drawing a horizontal line at y=0 (if needed)
# ax1.axhline(0, color="black", linewidth=0.8)

# Annotate bars with their values
for i in range(4):
    ax1.text(
        x[i],
        genre_a_sales[i] + 5,
        f"{genre_a_sales[i]}k",
        ha="center",
        color="black",
    )
    ax2.text(
        x[i] + 0.4,
        genre_b_sales[i] + 5,
        f"{genre_b_sales[i]}k",
        ha="center",
        color="black",
    )

ax1.set_ylim(ylim1)
ax1.set_yticks(yticks1)

ax2.set_ylim(ylim2)
ax2.set_yticks(yticks2)
ax2.set_yticklabels(yticks2)

# Add legends to the subplot
ax1.legend(loc="upper left", bbox_to_anchor=(0.0, 1.2))
ax1.grid(axis="y", linestyle="--")
ax1.set_axisbelow(True)
ax2.legend(loc="upper right", bbox_to_anchor=(1, 1.2))
ax2.grid(axis="y", linestyle="--")
ax2.set_axisbelow(True)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout
plt.tight_layout()
plt.savefig("bar_303.pdf", bbox_inches="tight")
