

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data for the bar charts
unemployment_rate = [5, 8, 10, 15]  # Unemployment rate in percentage
average_salary = [100, 70, 50, 30]  # Average salary in $k

x = np.arange(len(unemployment_rate))  # x-coordinates for the bars
job_sectors = ["Tech", "Healthcare", "Education", "Hospitality"]  # x-labels for the bars
labels = ["Unemployment Rate (%)", "Average Salary ($k)"]  # Labels for the legend
title = "Job Sector Analysis"  # Title for the plot
ylim1 = [-20, 20]  # y-axis limits for the first subplot
ylim2 = [-150, 150]  # y-axis limits for the second subplot
yticks1 = [0, 5, 10, 15, 20]  # y-ticks for the first subplot
yticks2 = [-150, -100, -50, 0, 50, 100, 150]  # y-ticks for the second subplot

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size to match the original image's dimensions
fig, ax1 = plt.subplots(figsize=(8, 6))

# Create the first subplot for 'unemployment_rate' using the left y-axis
ax1.bar(
    x,
    unemployment_rate,
    width=0.4,
    label=labels[0],
    color="#76b7b2",
    align="center",
)
ax1.set_ylabel(labels[0], color="#76b7b2")
ax1.tick_params(axis="y", labelcolor="#76b7b2")

# Create the second y-axis for 'average_salary'
ax2 = ax1.twinx()
ax2.bar(
    x,
    [-i for i in average_salary],
    width=0.4,
    label=labels[1],
    color="#ff9da7",
    align="center",
)
ax2.set_ylabel(labels[1], color="#ff9da7")
ax2.tick_params(axis="y", labelcolor="#ff9da7")

# Title for the plot
ax1.set_title(title)

# Set x-axis labels
ax1.set_xticks(x)
ax1.set_xticklabels(job_sectors)

# Drawing a horizontal line at y=0
ax1.axhline(0, color="black", linewidth=0.8)

# Annotate bars with their values
for j in range(4):
    ax1.text(
        x[j],
        unemployment_rate[j] + 1,
        f"{unemployment_rate[j]}%",
        ha="center",
        color="white",
    )
    ax2.text(
        x[j],
        -average_salary[j] - 5,
        f"{average_salary[j]}k",
        ha="center",
        color="#ff9da7",
    )

ax1.set_ylim(ylim1)
ax1.set_yticks(yticks1)

ax2.set_ylim(ylim2)
ax2.set_yticks(yticks2)
ax2.set_yticklabels(yticks2)
# Add legend to the subplot
ax1.legend(loc="upper left", bbox_to_anchor=(0.0, 1.2))
ax1.grid(axis="y", linestyle="--")
ax1.set_axisbelow(True)
ax2.legend(loc="upper right", bbox_to_anchor=(1, 1.2))
ax2.grid(axis="y", linestyle="--")
ax2.set_axisbelow(True)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout
plt.tight_layout()
plt.savefig("bar_305.pdf", bbox_inches="tight")

