

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
cities = ["New York", "Los Angeles", "Chicago", "Houston", "Phoenix"]
rainfall = [49.9, 14.9, 36.9, 49.5, 8.3]
xlabel = "City"
ylabel = "Average Annual Rainfall (inches)"
title = "Average Annual Rainfall in Different Cities"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(10, 6))
bar_colors = ["#76c7c0", "#80cbc4", "#82ada9", "#678d89", "#486d6c"]
plt.bar(cities, rainfall, color=bar_colors, edgecolor="black", linewidth=1.5)
plt.xlabel(xlabel, fontsize=12, fontweight='bold')
plt.ylabel(ylabel, fontsize=12, fontweight='bold')
plt.title(title, fontsize=14, fontweight='bold')
plt.grid(axis='y', linestyle='--', alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_309.pdf", bbox_inches="tight")

