

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
model_names = ["Model A", "Model B", "Model C", "Model D", "Model E"]
smartphone_sales = [15000, 12000, 18000, 10000, 16000]
xlabel = "Smartphone Model"
ylabel = "Average Monthly Sales"
title = "Average Monthly Smartphone Sales by Model"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(10, 5))
bars = plt.bar(model_names, smartphone_sales, color=["#FF6347", "#FFA500", "#8A2BE2", "#5F9EA0", "#FFD700"], 
               edgecolor="black", hatch="//")
plt.xlabel(xlabel, fontsize=12, fontweight='bold')
plt.ylabel(ylabel, fontsize=12, fontweight='bold')
plt.title(title, fontsize=14, fontweight='bold')
plt.grid(True, which='both', linestyle='--', linewidth=0.5, alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_310.pdf", bbox_inches="tight")

