

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
energy_sources = ["Solar", "Wind", "Hydro", "Nuclear", "Coal"]
avg_generation_capacity = [75.0, 50.0, 100.0, 200.0, 400.0]  # in Gigawatts (GW)
xlabel = "Energy Source"
ylabel = "Average Generation Capacity (in GW)"
title = "Average Generation Capacity by Energy Source"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(10, 6))
colors = ["#FF6F61", "#6B5B95", "#88B04B", "#F7CAC9", "#92A8D1"]
bars = plt.bar(energy_sources, avg_generation_capacity, color=colors, edgecolor="black")

# Stylize bars: Add rounded edges
for bar in bars:
    bar.set_linewidth(1.5)
    bar.set_linestyle('solid')
    bar.set_capstyle('round')

plt.xlabel(xlabel, fontsize=12)
plt.ylabel(ylabel, fontsize=12)
plt.title(title, fontsize=16, fontweight='bold')
plt.xticks(fontsize=10)
plt.yticks(fontsize=10)
plt.grid(axis='y', linestyle='--', alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_311.pdf", bbox_inches="tight")

