

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data points representing AQI in four cities
x = np.arange(4)  # X-axis points represent different cities
y1 = np.array([70, 80, 65, 90])  # AQI levels for 2019
y2 = np.array([68, 75, 60, 85])  # AQI levels for 2020
labels = ["2019 AQI Levels", "2020 AQI Levels"]
xticklabels = ["City A", "City B", "City C", "City D"]
title = "Annual AQI Levels Comparison"
ylim1 = [0, 100]
ylim2 = [0, 100]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax1 = plt.subplots(figsize=(10, 5))
width = 0.35  # Width of the bars

# Plotting data for the year 2019
ax1.bar(
    x,
    y1,
    color="#76c7c0",
    hatch="/",
    width=width,
    label=labels[0],
    edgecolor="black",
)

# Create a second y-axis sharing the same x-axis
ax2 = ax1.twinx()
ax2.bar(
    x + width,
    y2,
    color="#ffb3b3",
    hatch="\\",
    width=width,
    label=labels[1],
    edgecolor="black",
)

# Set the x-ticks to be in the middle of the two bars and add labels for the cities
ax1.set_xticks(x + width / 2)
ax1.set_xticklabels(xticklabels)

# Adding legends to the plot
ax1.legend(loc="upper left")
ax2.legend(loc="upper right")

# Labeling y-axes
ax1.set_ylabel(labels[0], color="#348888")
ax2.set_ylabel(labels[1], color="#b84242")

# Setting colors for y-axis
ax1.tick_params(axis="y", colors="#348888")
ax2.tick_params(axis="y", colors="#b84242")

# Setting the limits for y-axes
ax1.set_ylim(ylim1)
ax2.set_ylim(ylim2)

# Title for the chart
plt.title(title)

# ===================
# Part 4: Saving Output
# ===================
# Layout adjustment to prevent clipping
plt.tight_layout()

# Saving the plot as a PDF
plt.savefig("bar_313.pdf", bbox_inches="tight")

