
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(0)
# Example data for seasonal weather
groups = ["Spring", "Summer", "Autumn", "Winter"]
temperature_avg = [15, 30, 20, 5]
temperature_record_high = [25, 40, 30, 15]
precipitation_avg = [50, 80, 60, 30]
precipitation_record_high = [100, 150, 120, 50]

n_groups = len(groups)

labels = ["Avg Temperature", "Record High Temperature", "Avg Precipitation", "Record High Precipitation"]
xlabel = "Seasons"
ylabel = "Values"
title = "Seasonal Temperature and Precipitation Comparison"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(10, 5))

index = np.arange(n_groups)
bar_width = 0.2

opacity = 0.8

# Bar plots with new color scheme
rects1 = ax.bar(
    index - 1.5 * bar_width,
    temperature_avg,
    bar_width,
    alpha=opacity,
    color="#93C572",  # Green for avg temperature
    label=labels[0],
)

rects2 = ax.bar(
    index - 0.5 * bar_width,
    temperature_record_high,
    bar_width,
    alpha=opacity,
    color="#3A7CA5",  # Blue for record high temperature
    label=labels[1],
)

rects3 = ax.bar(
    index + 0.5 * bar_width,
    precipitation_avg,
    bar_width,
    alpha=opacity,
    color="#FFC300",  # Yellow for avg precipitation
    label=labels[2],
)

rects4 = ax.bar(
    index + 1.5 * bar_width,
    precipitation_record_high,
    bar_width,
    alpha=opacity,
    color="#FF5733",  # Red for record high precipitation
    hatch="x",
    label=labels[3],
)

# Setting the chart details
ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)
ax.set_title(title, fontsize=14)
ax.set_xticks(index)
ax.set_xticklabels(groups)
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.yaxis.grid(True, linestyle="--")
plt.legend()

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_319.pdf", bbox_inches="tight")
