

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Data
N = 5
streaming_hours = (7.8, 10.2, 8.5, 6.5, 5.0)
social_media_hours = (12.0, 10.6, 9.3, 7.1, 6.0)
news_consumption_hours = (3.5, 4.0, 3.8, 3.2, 2.5)

# Age groups
ind = np.arange(N)  # the x locations for the groups
width = 0.25  # the width of the bars

# Axes Limits and Labels
ylabel_value = "Average Hours per Week"
xlabel_value = "Age Groups"
legend_labels = (
    "Streaming Services",
    "Social Media",
    "News Consumption",
)
title_value = "Media Consumption Across Age Groups"
age_group_labels = ("18-25", "26-35", "36-45", "46-55", "56+")


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig = plt.figure(figsize=(10, 7))
ax = fig.add_subplot(111)
colors = (
    "#4F6272",  # Streaming Services
    "#8CB369",  # Social Media
    "#EFC050",  # News Consumption
)
rects1 = ax.bar(ind, streaming_hours, width, color=colors[0])
rects2 = ax.bar(ind + width, social_media_hours, width, color=colors[1])
rects3 = ax.bar(ind + 2 * width, news_consumption_hours, width, color=colors[2])

ax.set_ylabel(ylabel_value)
ax.set_xlabel(xlabel_value)
ax.set_title(title_value)
ax.set_xticks(ind + width)
ax.set_xticklabels(age_group_labels)

ax.legend(
    (rects1[0], rects2[0], rects3[0]),
    legend_labels,
)

ax.grid(True, linestyle='--', linewidth=0.5, axis='y')

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_81.pdf", bbox_inches="tight")

