
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Generate new data representing average monthly screen time (hours)
np.random.seed(0)
N = 5
netflix = (60, 75, 85, 70)
hulu = (55, 65, 70, 60)
amazon_prime = (50, 60, 80, 65)
disney_plus = (45, 55, 60, 50)
youtube = (70, 90, 100, 80)

# x locations for the groups and bar width
ind = np.arange(4)
width = 0.15

# Axes Limits and Labels
ylabel_value = "Screen Time (Hours)"
xlabel_value = "Months"
title_value = "Average Monthly Screen Time on Different Streaming Platforms"
legend_labels = (
    "Netflix",
    "Hulu",
    "Amazon Prime",
    "Disney+",
    "YouTube",
)
xlim_values = [-0.3, 3.7]
xticklabels = ("January", "February", "March", "April")

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig = plt.figure(figsize=(10, 6))
ax = fig.add_subplot(111)
colors = (
    "#66c2a5",  # Green
    "#fc8d62",  # Red-orange
    "#8da0cb",  # Blue
    "#e78ac3",  # Pink
    "#a6d854",  # Light green
)

rects1 = ax.bar(ind, netflix, width, color=colors[0])
rects2 = ax.bar(ind + width, hulu, width, color=colors[1])
rects3 = ax.bar(ind + 2 * width, amazon_prime, width, color=colors[2])
rects4 = ax.bar(ind + 3 * width, disney_plus, width, color=colors[3])
rects5 = ax.bar(ind + 4 * width, youtube, width, color=colors[4])

ax.set_ylabel(ylabel_value)
ax.set_xlabel(xlabel_value)
ax.set_title(title_value)
ax.set_xlim(xlim_values)
ax.set_xticks(ind + 2 * width)
ax.set_xticklabels(xticklabels)
ax.legend((rects1[0], rects2[0], rects3[0], rects4[0], rects5[0]), legend_labels)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_82.pdf", bbox_inches="tight")
