
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Sample data
time = np.arange(0, 45, 5)
crops = np.array([0.25, 0.28, 0.30, 0.32, 0.31, 0.29, 0.28, 0.30, 0.31])
livestock = np.array([0.20, 0.22, 0.21, 0.20, 0.22, 0.21, 0.23, 0.22, 0.21])
dairy = np.array([0.18, 0.16, 0.19, 0.18, 0.17, 0.19, 0.18, 0.17, 0.18])
fruit = np.array([0.15, 0.12, 0.13, 0.12, 0.14, 0.13, 0.12, 0.14, 0.13])
vegetables = np.array([0.22, 0.22, 0.17, 0.18, 0.16, 0.18, 0.19, 0.17, 0.17])
width = 2

barlabel = ["Crops", "Livestock", "Dairy", "Fruit", "Vegetables"]
xlabel = "Time (Months)"
ylabel = "Yield Percentage"
title = "Agricultural Yield Distribution Over Time"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xticks = [0, 10, 20, 30, 40]
colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728", "#9467bd"]

# Stacked bar chart
plt.figure(figsize=(8, 4))
plt.bar(time, crops, width, color=colors[0], label=barlabel[0])
plt.bar(time, livestock, width, bottom=crops, color=colors[1], label=barlabel[1])
plt.bar(time, dairy, width, bottom=crops + livestock, color=colors[2], label=barlabel[2])
plt.bar(time, fruit, width, bottom=crops + livestock + dairy, color=colors[3], label=barlabel[3])
plt.bar(time, vegetables, width, bottom=crops + livestock + dairy + fruit, color=colors[4], label=barlabel[4])

# Labels and title
plt.xticks(xticks)
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)

# Legend
plt.legend(loc="upper right", bbox_to_anchor=(1.25, 1))

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_84.pdf", bbox_inches="tight")

