
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data
labels = [
    "In-person Consultation", "Home Visits", "Phone Consultation", "Telemedicine", "Mobile Health Apps", "Email Consultation", "Online Health Forums"
]
traditional_methods = [55, 45, 50, 0, 0, 0, 0]
modern_methods = [0, 0, 0, 70, 65, 40, 50]

line_y_1 = 50
line_y_2 = 60
line_x_1 = 2.5
line_x_2 = 4.5

# Labels and Plot Types
label_Traditional = "Traditional Methods"
label_Modern = "Modern Methods"
legend_title = "Healthcare Delivery Methods"

# Axes Limits and Labels
ylabel_value = "Efficiency Metric"
title_value = "Comparative Analysis of Healthcare Delivery Methods"


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
x = np.arange(len(labels))  # the label locations
width = 0.7  # the width of the bars
ylim_values = [0, 80]
xlim_values = [-0.6, 7]

color_traditional = "#6897bb"
color_modern = "#77dd77"

# Plotting
fig, ax = plt.subplots(
    figsize=(10, 5)
)  # Adjust the size to match the original image's dimensions
rects1 = ax.bar(x, traditional_methods, width, label=label_Traditional, color=color_traditional)
rects2 = ax.bar(x, modern_methods, width, label=label_Modern, color=color_modern)

# Add some text for labels, title and custom x-axis tick labels, etc.
ax.set_ylabel(ylabel_value)
ax.set_title(title_value)
ax.set_xticks(x)
ax.set_xticklabels(labels, rotation=45, ha="center")
ax.set_ylim(ylim_values)
ax.set_xlim(xlim_values)

# Adding the values on top of the bars
for rect in rects1:
    if rect.get_height() > 0:
        height = rect.get_height()
        ax.annotate(
            "{}".format(height),
            xy=(rect.get_x() + rect.get_width() / 2, height),
            xytext=(0, 3),  # 3 points vertical offset
            textcoords="offset points",
            ha="center",
            va="bottom",
        )
for rect in rects2:
    if rect.get_height() > 0:
        height = rect.get_height()
        ax.annotate(
            "{}".format(height),
            xy=(rect.get_x() + rect.get_width() / 2, height),
            xytext=(0, 3),  # 3 points vertical offset
            textcoords="offset points",
            ha="center",
            va="bottom",
        )

# Reference lines
ax.axhline(y=line_y_1, color="red", linestyle="--")
ax.axhline(y=line_y_2, color="gray", linestyle="--")
ax.axvline(x=line_x_1, color="gray", linestyle="--")
ax.axvline(x=line_x_2, color="gray", linestyle="--")

# Hide the ticks
ax.tick_params(axis="both", which="both", length=0)

# Hide the right and top spines
ax.spines["right"].set_visible(False)
ax.spines["top"].set_visible(False)
ax.legend(title=legend_title)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_91.pdf", bbox_inches="tight")
