

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data for the bar chart
departments = ["R&D", "Marketing", "Sales", "HR"]
quarter_1 = [22000, 28000, 25000, 24000]
quarter_2 = [26000, 30000, 27000, 26000]
quarter_3 = [24000, 32000, 29000, 27000]

labels = ["Quarter 1", "Quarter 2", "Quarter 3"]
ylabel = "Quarterly Expenses (in USD)"

y_index = [0, 5000, 10000, 15000, 20000, 25000, 30000, 35000]
y_label_ticks = ["0", "5k", "10k", "15k", "20k", "25k", "30k", "35k"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
ylim = [0, 37000]

# Set the figure size
plt.figure(figsize=(10, 5))

# Create the bar chart
bar_width = 0.2
index = np.arange(len(departments))

plt.bar(
    index - bar_width,
    quarter_1,
    width=bar_width,
    color="#81c784",
    edgecolor="black",
    hatch='/',
    label=labels[0],
)
plt.bar(
    index,
    quarter_2,
    width=bar_width,
    color="#64b5f6",
    edgecolor="black",
    hatch='\\',
    label=labels[1],
)
plt.bar(
    index + bar_width,
    quarter_3,
    width=bar_width,
    color="#e57373",
    edgecolor="black",
    hatch='|',
    label=labels[2],
)

# Add the text labels on top of the bars
for i in index:
    plt.text(
        i - bar_width, quarter_1[i] + 1000, f"{quarter_1[i]/1000:.1f}k", ha="center"
    )
    plt.text(i, quarter_2[i] + 1000, f"{quarter_2[i]/1000:.1f}k", ha="center")
    plt.text(i + bar_width, quarter_3[i] + 1000, f"{quarter_3[i]/1000:.1f}k", ha="center")

# Set the x-axis labels, y-axis label, and chart title
plt.xticks(index, departments)
plt.ylabel(ylabel)
plt.ylim(ylim)
plt.yticks(y_index, y_label_ticks)

# Add a legend
plt.legend(loc="upper center", bbox_to_anchor=(0.5, 1.15), ncol=3)

# Add grid lines
plt.grid(axis='y', linestyle='--', alpha=0.7)

# Hide the right and top spines
plt.gca().spines["right"].set_visible(False)
plt.gca().spines["top"].set_visible(False)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_94.pdf", bbox_inches="tight")

