
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for the bar chart
quarters = ["Q1", "Q2", "Q3"]
product_a_sales = [150, 200, 180]
product_b_sales = [170, 210, 190]
product_c_sales = [160, 220, 200]

labels = ["Product A Sales", "Product B Sales", "Product C Sales"]
ylabel = "Quarterly Sales (USD Thousands)"
xlabel = "Quarters"
title = "Quarterly Sales by Product Category"
legend_labels = ["Product A", "Product B", "Product C"]
annotation_text = ["150k", "200k", "180k", "170k", "210k", "190k", "160k", "220k", "200k"]

y_index = [0, 50, 100, 150, 200, 250]
ylim = [0, 250]
y_label_ticks = ["0", "50k", "100k", "150k", "200k", "250k"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size
plt.figure(figsize=(10, 6))

# Create the bar chart
bar_width = 0.25
index = range(len(quarters))

plt.bar(
    [i - bar_width for i in index],
    product_a_sales,
    width=bar_width,
    color="#FFD700",  # Product A: Yellow
    edgecolor="black",
    label=labels[0],
)
plt.bar(
    index,
    product_b_sales,
    width=bar_width,
    color="#32CD32",  # Product B: Green
    edgecolor="black",
    label=labels[1],
)
plt.bar(
    [i + bar_width for i in index],
    product_c_sales,
    width=bar_width,
    color="#1E90FF",  # Product C: Blue
    edgecolor="black",
    label=labels[2],
)

# Add the text labels on top of the bars
for i in range(len(quarters)):
    plt.text(
        i - bar_width,
        product_a_sales[i] + 5,
        f"{product_a_sales[i]}k",
        ha="center",
    )
    plt.text(
        i,
        product_b_sales[i] + 5,
        f"{product_b_sales[i]}k",
        ha="center",
    )
    plt.text(
        i + bar_width,
        product_c_sales[i] + 5,
        f"{product_c_sales[i]}k",
        ha="center",
    )

# Set the x-axis labels, y-axis label, and chart title
plt.xticks(index, quarters)
plt.ylabel(ylabel)
plt.xlabel(xlabel)
plt.title(title)
plt.ylim(ylim)
plt.yticks(y_index, y_label_ticks)

# Add a legend
plt.legend(loc="upper center", bbox_to_anchor=(0.5, 1.15), ncol=3)

# Hide the right and top spines
plt.gca().spines["right"].set_visible(False)
plt.gca().spines["top"].set_visible(False)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_95.pdf", bbox_inches="tight")
