
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Environmental event labels
events = [
    "CO2 Emissions Increase",
    "Amazon Deforestation",
    "Temperature Anomalies",
    "Arctic Ice Melt",
    "Sea Level Rise",
    "Biodiversity Loss",
    "Air Pollution Levels",
    "Coral Bleaching Events",
    "Extreme Weather Events",
    "Ozone Layer Depletion",
    "Plastic Pollution",
    "Ocean Acidification",
    "Wildfires",
    "Water Scarcity",
    "Renewable Energy Adoption"
]

# Impact values
impact = [
    7.5,
    6.8,
    8.4,
    7.2,
    7.9,
    6.5,
    6.2,
    5.9,
    7.3,
    6.7,
    5.4,
    6.9,
    7.1,
    5.8,
    8.0
]

xlabel = "Impact Score"
ylabel = "Environmental Events"
title = "Impact of Significant Environmental Metrics"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xticks = list(range(5, 10))
xlim = [5, 9]
bar_color = "#b58900"

# Create horizontal bar chart
plt.figure(figsize=(10, 10))  # Adjust figure size for better visualization
plt.barh(events, impact, color=bar_color)

# Set x-axis limits
plt.xlim(xlim)

# Set x-axis ticks
plt.xticks(xticks)

# Set labels and title
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)

# Add grid for better readability
plt.grid(True, which='both', linestyle='--', linewidth=0.5, color='grey', axis='x')

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_96.pdf", bbox_inches="tight")
