

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Scientific fields
scientific_fields = [
    "Physics",
    "Chemistry",
    "Biology",
    "Astronomy",
    "Geology",
    "Medicine",
    "Ecology",
    "Genetics",
    "Neuroscience",
    "Mathematics",
    "Computer Science",
    "Engineering",
    "Materials Science",
    "Environmental Science",
    "Paleontology",
]

# Approximate prevalence values (hypothetical data)
prevalences = np.random.uniform(10.0, 50.0, len(scientific_fields)).tolist()

xlabel = "Prevalence (%)"
ylabel = "Scientific Fields"
title = "Prevalence of Scientific Fields in Research"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xticks = list(range(0, 51, 5))
xlim = [0, 50.5]

# Create horizontal bar chart
plt.figure(figsize=(10, 8))  # Adjust figure size
plt.barh(scientific_fields, prevalences, color="#6a5acd", edgecolor="black")

# Set x-axis limits
plt.xlim(xlim)

# Set x-axis ticks
plt.xticks(xticks)

# Set labels and title
plt.xlabel(xlabel, fontsize=12, fontweight="bold")
plt.ylabel(ylabel, fontsize=12, fontweight="bold")
plt.title(title, fontsize=14, fontweight="bold")

# Improve visual aesthetics
plt.grid(True, axis='x', linestyle='--', alpha=0.6)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_98.pdf", bbox_inches="tight")
