
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(0)

# Data
categories = ["Cardio", "Strength", "Flexibility"]
before_treatment = [-5.2, -4.8, -2.1]
after_treatment = [3.5, 6.4, 2.8]
improvement_index = [0.4, 0.55, 0.35]

labels = ["Before Treatment", "After Treatment", "Improvement Index"]
xlabel = "Health Metrics"
ylabel = "Scores (%)"
ylabel2 = "Improvement Index"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xticks = np.arange(len(categories))
ylim = [-10, 10]
ylim2 = [-1, 1]
num_yticks = 5
yticks = np.linspace(-10, 10, num_yticks)
yticks2 = np.linspace(0, 1, num_yticks)

# Create figure and axes
fig, ax1 = plt.subplots(figsize=(8, 6))
ax2 = ax1.twinx()

# Bar plots
bar_width = 0.2
index = np.arange(len(categories))

bar1 = ax1.bar(
    index - bar_width,
    before_treatment,
    bar_width,
    label=labels[0],
    color="#2E8B57",
    edgecolor="black",
    zorder=3,
)
bar2 = ax1.bar(
    index,
    after_treatment,
    bar_width,
    label=labels[1],
    color="#FF6347",
    edgecolor="black",
    zorder=3,
)
bar3 = ax2.bar(
    index + bar_width,
    improvement_index,
    bar_width,
    label=labels[2],
    color="#4682B4",
    edgecolor="black",
    zorder=3,
)

# Add values on top of the bars
for bars in [bar1, bar2]:
    for bar in bars:
        height = bar.get_height()
        ax1.annotate(
            f"{height}",
            xy=(bar.get_x() + bar.get_width() / 2, height - 0.4),
            xytext=(0, 3),
            textcoords="offset points",
            ha="center",
            va="top",
            fontsize=8,
        )
for bars in [bar3]:
    for bar in bars:
        height = bar.get_height()
        ax2.annotate(
            f"{height}",
            xy=(bar.get_x() + bar.get_width() / 2, height),
            xytext=(0, 3),
            textcoords="offset points",
            ha="center",
            va="bottom",
            fontsize=8,
        )

# Set the axes background color and add grid lines
for ax in [ax1, ax2]:
    ax.set_facecolor("#f5f5f5")
    ax.grid(True, color="#d9d9d9", linestyle='--', zorder=1)

# Axes labels
ax1.set_xlabel(xlabel)
ax1.set_ylabel(ylabel)
ax2.set_ylabel(ylabel2)

ax1.set_ylim(ylim)
ax2.set_ylim(ylim2)
ax1.set_xticks(index)
ax1.set_xticklabels(categories)

ax1.set_yticks(yticks)
ax2.set_yticks(yticks2)

# Create legend & Show plot
handles, labels = ax1.get_legend_handles_labels()
handles2, labels2 = ax2.get_legend_handles_labels()
fig.legend(
    handles + handles2,
    labels + labels2,
    loc="lower right",
    bbox_to_anchor=(0.9, 0.1),
    frameon=False,
    framealpha=0,
)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_99.pdf", bbox_inches="tight")
