
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.lines as mlines
import matplotlib.patches as mpatches

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Generate sample data for box office returns
action_returns = [np.random.normal(70, std, 50) for std in np.random.uniform(20, 50, 5)]
comedy_returns = [np.random.normal(50, std, 50) for std in np.random.uniform(15, 40, 5)]
drama_returns = [np.random.normal(40, std, 50) for std in np.random.uniform(10, 30, 5)]
labels = ["Action", "Comedy", "Drama", "Industry Average"]
vlines = [10, 90]
xlim = [-40, 180]
ylabel = "Box Office Returns [Millions]"
xlabel = "Year"
linelabel=["Lower Threshold", "Upper Threshold"]
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Boxplot
fig, ax = plt.subplots(figsize=(12, 8))  # Adjust figure size

bp1 = ax.boxplot(
    action_returns,
    positions=np.array(range(len(action_returns))) * 2.0 - 0.4,
    widths=0.3,
    patch_artist=True,
    vert=False,
    showfliers=False,
)
bp2 = ax.boxplot(
    comedy_returns,
    positions=np.array(range(len(comedy_returns))) * 2.0,
    widths=0.3,
    patch_artist=True,
    vert=False,
    showfliers=False,
)
bp3 = ax.boxplot(
    drama_returns,
    positions=np.array(range(len(drama_returns))) * 2.0 + 0.4,
    widths=0.3,
    patch_artist=True,
    vert=False,
    showfliers=False,
)

# New colors for the boxplots
new_colors = ["#ff9999", "#66b3ff", "#99ff99"]

# Set properties for each boxplot
for bp, color in zip([bp1, bp2, bp3], new_colors):
    for patch in bp["boxes"]:
        patch.set_facecolor(color)
    for whisker in bp["whiskers"]:
        whisker.set(color="black", linewidth=1)
    for cap in bp["caps"]:
        cap.set(color="black", linewidth=1)
    for median in bp["medians"]:
        median.set(color="black", linewidth=2)

# Add dashed line for significant thresholds adjusted for horizontal layout
ax.axvline(
    x=vlines[0], color="#d62728", linestyle="--", linewidth=1.5, label=linelabel[0]
)
ax.axvline(
    x=vlines[1], color="#2ca02c", linestyle="--", linewidth=1.5, label=linelabel[1]
)

# Add legend with updated colors and markers
legend_elements = [
    mpatches.Patch(color="#ff9999", label=labels[0]),
    mpatches.Patch(color="#66b3ff", label=labels[1]),
    mpatches.Patch(color="#99ff99", label=labels[2]),
    mlines.Line2D([], [], color="#d62728", linestyle="--", label=linelabel[0]),
    mlines.Line2D([], [], color="#2ca02c", linestyle="--", label=linelabel[1])
]

# Place legend outside the plot area
ax.legend(
    handles=legend_elements,
    loc="upper center",
    bbox_to_anchor=(0.5, -0.1),
    ncol=3,
    frameon=False,
)

# Set y-axis labels and limits
ax.set_xlim(xlim)
ax.set_ylabel(ylabel)
ax.set_xlabel(xlabel)

# Set y-axis tick positions and labels
ax.set_yticks(range(0, len(action_returns) * 2, 2))
ax.set_yticklabels(["2018", "2019", "2020", "2021", "2022"])

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("box_100.pdf", bbox_inches="tight")
