

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)
# Sample data for the domain of economics
gdp_growth_rate_data = [
    np.random.normal(3, 0.5, 100),  # Our Model
    np.random.normal(2, 0.7, 100),  # Benchmark
]
inflation_rate_data = [
    np.random.normal(1.5, 0.3, 100),  # Our Model
    np.random.normal(2.5, 0.5, 100),  # Benchmark
]

# Text labels
title_1 = "GDP Growth Rate"
title_2 = "Inflation Rate"
xticklabels = ["Our Model", "Benchmark"]
xlabel = "Methods"
ylabel_gdp = "Growth Rate (%)"
ylabel_inflation = "Inflation Rate (%)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size
plt.figure(figsize=(10, 8))

# Create subplots
fig, axs = plt.subplots(2, 2)

# Plot the boxplots
bp1 = axs[0, 0].boxplot(
    gdp_growth_rate_data,
    patch_artist=True,
    widths=0.5,
    showfliers=False,
    medianprops=dict(color="darkblue", linestyle='--', linewidth=1.5),
)
bp2 = axs[0, 1].boxplot(
    inflation_rate_data,
    patch_artist=True,
    widths=0.5,
    showfliers=False,
    medianprops=dict(color="darkgreen", linestyle='--', linewidth=1.5),
)
bp3 = axs[1, 0].boxplot(
    gdp_growth_rate_data,
    patch_artist=True,
    widths=0.5,
    showfliers=False,
    medianprops=dict(color="darkblue", linestyle='--', linewidth=1.5),
)
bp4 = axs[1, 1].boxplot(
    inflation_rate_data,
    patch_artist=True,
    widths=0.5,
    showfliers=False,
    medianprops=dict(color="darkgreen", linestyle='--', linewidth=1.5),
)

# Set the colors of the boxes
colors_gdp = ["#a6cee3", "#1f78b4"]
colors_inflation = ["#b2df8a", "#33a02c"]

for bp in [bp1, bp3]:
    for patch, color in zip(bp["boxes"], colors_gdp):
        patch.set_facecolor(color)

for bp in [bp2, bp4]:
    for patch, color in zip(bp["boxes"], colors_inflation):
        patch.set_facecolor(color)

# Set titles and labels
axs[0, 0].set_title(title_1)
axs[0, 0].set_ylabel(ylabel_gdp)
axs[0, 1].set_title(title_2)
axs[0, 1].set_ylabel(ylabel_inflation)
axs[0, 0].grid(True, linestyle='--', alpha=0.7)
axs[0, 1].grid(True, linestyle='--', alpha=0.7)
axs[0, 0].set_xticklabels(xticklabels)
axs[0, 1].set_xticklabels(xticklabels)
axs[1, 0].set_title(title_1)
axs[1, 1].set_title(title_2)
axs[1, 0].grid(True, linestyle='--', alpha=0.7)
axs[1, 1].grid(True, linestyle='--', alpha=0.7)
axs[1, 0].set_xticklabels(xticklabels)
axs[1, 1].set_xticklabels(xticklabels)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("box_30.pdf", bbox_inches="tight")

