

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.patches as mpatches

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# New data generation simulating tourist visits to different destinations
data_Beach = np.random.normal(500, 100, 100)
data_Mountain = np.random.normal(450, 90, 100)
data_City = np.random.normal(700, 120, 100)
data_Countryside = np.random.normal(300, 80, 100)

data = [data_Beach, data_Mountain, data_City, data_Countryside]

# Labels and Plot Types
legend_labels = ["Beach", "Mountain", "City", "Countryside"]

# Axes Limits and Labels
xticklabels = ["Beach", "Mountain", "City", "Countryside"]
ylabel_value = "Number of Tourist Visits"
ylim_values = [0, 1000]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the boxplot
fig, ax = plt.subplots(figsize=(8, 6))  # Adjusting figure size
bp = ax.boxplot(data, patch_artist=True, notch=False, showfliers=False)

# Customizing the boxplot colors
colors = ["#1f77b4", "#2ca02c", "#ff7f0e", "#d62728"]
for patch, color in zip(bp["boxes"], colors):
    patch.set_facecolor(color)

# Customizing the boxplot median lines
for median in bp["medians"]:
    median.set(color="black", linewidth=2)

legend_patches = [
    mpatches.Patch(color=color, label=label)
    for color, label in zip(colors, legend_labels)
]
ax.legend(handles=legend_patches, loc="upper right")

# Setting the x-axis labels
ax.set_xticklabels(xticklabels)

# Setting the y-axis label
ax.set_ylabel(ylabel_value)

# Setting the y-axis limits
ax.set_ylim(ylim_values)

# Adding grid lines
ax.yaxis.grid(True, which="major", color="grey", alpha=0.5)

ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)

# Adding a title
ax.set_title("Tourist Visits Across Different Destinations")

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("box_33.pdf", bbox_inches="tight")

