

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.patches as mpatches

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Simulated energy consumption data (in gigawatt-hours)
data_residential = np.random.normal(300, 50, 100)
data_commercial = np.random.normal(450, 60, 100)
data_industrial = np.random.normal(600, 80, 100)
data_transportation = np.random.normal(350, 70, 100)

data = [data_residential, data_commercial, data_industrial, data_transportation]

# Labels and Plot Types
legend_labels = ["Residential", "Commercial", "Industrial", "Transportation"]

# Axes Limits and Labels
xticklabels = ["Residential", "Commercial", "Industrial", "Transportation"]
ylabel_value = "Energy Consumption (GWh)"
title = "Energy Consumption Comparison Across Sectors"
ylim_values = [100, 800]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the boxplot
fig, ax = plt.subplots(
    figsize=(10, 7)
)  # Adjusting figure size for better readability
bp = ax.boxplot(data, patch_artist=True, notch=False, showfliers=False)

# Customizing the boxplot colors
colors = ["#8FBC8F", "#DEB887", "#F4A460", "#FFD700"]
for patch, color in zip(bp["boxes"], colors):
    patch.set_facecolor(color)

# Customizing the boxplot median lines
for median in bp["medians"]:
    median.set(color="black", linewidth=1.5)

legend_patches = [
    mpatches.Patch(color=color, label=label)
    for color, label in zip(colors, legend_labels)
]
ax.legend(handles=legend_patches, loc="upper right")

# Setting the x-axis labels
ax.set_xticklabels(xticklabels)

# Setting the y-axis label
ax.set_ylabel(ylabel_value)

# Setting the plot title
ax.set_title(title)

# Setting the y-axis limits
ax.set_ylim(ylim_values)

# Adding grid lines
ax.yaxis.grid(True, which="major", color="grey", alpha=0.5)

# Removing top and right spines for a cleaner look
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("box_34.pdf", bbox_inches="tight")

