

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(0)

# Sample data
religions = ["Christianity", "Islam", "Hinduism", "Buddhism", "Judaism", "Sikhism"]
participation_scores = [7.8, 6.7, 6.0, 5.5, 4.3, 4.0]
faith_scores = [8.5, 7.9, 6.8, 5.9, 5.1, 4.8]
community_scores = [7.2, 6.5, 6.1, 5.8, 4.6, 4.4]
outreach_scores = [6.5, 5.9, 5.3, 4.7, 3.9, 3.5]

# Generate random data for box plots
data1 = [np.random.normal(participation, 1, 100) for participation in participation_scores]
data2 = [np.random.normal(faith, 1, 100) for faith in faith_scores]
data3 = [np.random.normal(community, 1, 100) for community in community_scores]
data4 = [np.random.normal(outreach, 1, 100) for outreach in outreach_scores]

xlabel = "Score"
titles = ["Participation Score (↑)", "Faith Score (↑)", "Community Engagement (↑)", "Outreach Efforts (↑)"]
axhline = 5

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(12, 3))

# New color palette (retain from provided code)
colors = ["skyblue", "salmon", "lightgreen", "khaki", "plum", "orange"]

# Create subplots
ax1 = plt.subplot(141)
ax2 = plt.subplot(142)
ax3 = plt.subplot(143)
ax4 = plt.subplot(144)

# Plotting
boxplot1 = ax1.boxplot(
    data1,
    vert=False,
    patch_artist=True,
    medianprops={"color": "black"},
    whiskerprops=dict(color="black", linestyle="-", linewidth=0.5),
    showcaps=False,
    showfliers=False,
    boxprops=dict(linestyle="-", linewidth=0.5),
)
boxplot2 = ax2.boxplot(
    data2,
    vert=False,
    patch_artist=True,
    medianprops={"color": "black"},
    whiskerprops=dict(color="black", linestyle="-", linewidth=0.5),
    showcaps=False,
    showfliers=False,
    boxprops=dict(linestyle="-", linewidth=0.5),
)
boxplot3 = ax3.boxplot(
    data3,
    vert=False,
    patch_artist=True,
    medianprops={"color": "black"},
    whiskerprops=dict(color="black", linestyle="-", linewidth=0.5),
    showcaps=False,
    showfliers=False,
    boxprops=dict(linestyle="-", linewidth=0.5),
)
boxplot4 = ax4.boxplot(
    data4,
    vert=False,
    patch_artist=True,
    medianprops={"color": "black"},
    whiskerprops=dict(color="black", linestyle="-", linewidth=0.5),
    showcaps=False,
    showfliers=False,
    boxprops=dict(linestyle="-", linewidth=0.5),
)

for bplot in [boxplot1, boxplot2, boxplot3, boxplot4]:
    for patch, color in zip(bplot["boxes"], colors):
        patch.set_facecolor(color)

# Set labels and titles
ax1.set_yticklabels(religions)
ax1.set_xlabel(xlabel)
ax1.set_title(titles[0])
ax1.spines["top"].set_visible(False)
ax1.spines["left"].set_visible(False)
ax1.spines["right"].set_visible(False)
ax1.xaxis.grid(True, alpha=0.7)
ax1.invert_yaxis()
ax1.axhline(axhline, color="black", linewidth=1)

ax2.set_yticks([])
ax2.set_xlabel(xlabel)
ax2.set_title(titles[1])
ax2.spines["top"].set_visible(False)
ax2.spines["left"].set_visible(False)
ax2.spines["right"].set_visible(False)
ax2.xaxis.grid(True, alpha=0.7)
ax2.invert_yaxis()
ax2.axhline(axhline, color="black", linewidth=1)

ax3.set_yticks([])
ax3.set_xlabel(xlabel)
ax3.set_title(titles[2])
ax3.spines["top"].set_visible(False)
ax3.spines["left"].set_visible(False)
ax3.spines["right"].set_visible(False)
ax3.xaxis.grid(True, alpha=0.7)
ax3.invert_yaxis()
ax3.axhline(axhline, color="black", linewidth=1)

ax4.set_yticks([])
ax4.set_xlabel(xlabel)
ax4.set_title(titles[3])
ax4.spines["top"].set_visible(False)
ax4.spines["left"].set_visible(False)
ax4.spines["right"].set_visible(False)
ax4.xaxis.grid(True, alpha=0.7)
ax4.invert_yaxis()
ax4.axhline(axhline, color="black", linewidth=1)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("box_35.pdf", bbox_inches="tight")

