
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Sample data for entertainment domain
genres = ["Action", "Comedy", "Drama", "Horror", "Romance", "Sci-Fi"]
avg_rating = [6.5, 6.8, 7.2, 5.9, 7.0, 7.4]
box_office = [200, 150, 140, 90, 130, 180]  # in million dollars
num_reviews = [300, 250, 350, 200, 280, 320]
avg_duration = [120, 110, 140, 100, 115, 130]  # in minutes

# Generate random data for box plots based on the sample data
rating_data = [np.random.normal(rating, 0.5, 100) for rating in avg_rating]
box_office_data = [np.random.normal(box, 20, 100) for box in box_office]
reviews_data = [np.random.normal(reviews, 30, 100) for reviews in num_reviews]
duration_data = [np.random.normal(duration, 10, 100) for duration in avg_duration]

xlabel = "Values"
titles = ["Average Rating", "Box Office Collection (M$)", "Number of Reviews", "Average Duration (min)"]
axhline = 0

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(12, 3))
colors = ["#ff6666", "#66b3ff", "#99ff99", "#ffcc99", "#c2c2f0", "#ffb3e6"]

ax1 = plt.subplot(141)
ax2 = plt.subplot(142)
ax3 = plt.subplot(143)
ax4 = plt.subplot(144)

# Plotting
boxplot1 = ax1.boxplot(
    rating_data,
    vert=False,
    patch_artist=True,
    medianprops={"color": "black"},
    whiskerprops=dict(color="black", linestyle="-", linewidth=1),
    showcaps=False,
    showfliers=False,
    boxprops=dict(linestyle="-", linewidth=1),
)
boxplot2 = ax2.boxplot(
    box_office_data,
    vert=False,
    patch_artist=True,
    medianprops={"color": "black"},
    whiskerprops=dict(color="black", linestyle="-", linewidth=1),
    showcaps=False,
    showfliers=False,
    boxprops=dict(linestyle="-", linewidth=1),
)
boxplot3 = ax3.boxplot(
    reviews_data,
    vert=False,
    patch_artist=True,
    medianprops={"color": "black"},
    whiskerprops=dict(color="black", linestyle="-", linewidth=1),
    showcaps=False,
    showfliers=False,
    boxprops=dict(linestyle="-", linewidth=1),
)
boxplot4 = ax4.boxplot(
    duration_data,
    vert=False,
    patch_artist=True,
    medianprops={"color": "black"},
    whiskerprops=dict(color="black", linestyle="-", linewidth=1),
    showcaps=False,
    showfliers=False,
    boxprops=dict(linestyle="-", linewidth=1),
)

for bplot in [boxplot1, boxplot2, boxplot3, boxplot4]:
    for patch, color in zip(bplot["boxes"], colors):
        patch.set_facecolor(color)

# Set labels and titles
ax1.set_yticklabels(genres)
ax1.set_xlabel(xlabel)
ax1.set_title(titles[0])
ax1.spines["top"].set_visible(False)
ax1.spines["left"].set_visible(False)
ax1.spines["right"].set_visible(False)
ax1.xaxis.grid(True, alpha=0.7)
ax1.invert_yaxis()

ax2.set_yticks([])
ax2.set_xlabel(xlabel)
ax2.set_title(titles[1])
ax2.spines["top"].set_visible(False)
ax2.spines["left"].set_visible(False)
ax2.spines["right"].set_visible(False)
ax2.xaxis.grid(True, alpha=0.7)
ax2.invert_yaxis()

ax3.set_yticks([])
ax3.set_xlabel(xlabel)
ax3.set_title(titles[2])
ax3.spines["top"].set_visible(False)
ax3.spines["left"].set_visible(False)
ax3.spines["right"].set_visible(False)
ax3.xaxis.grid(True, alpha=0.7)
ax3.invert_yaxis()

ax4.set_yticks([])
ax4.set_xlabel(xlabel)
ax4.set_title(titles[3])
ax4.spines["top"].set_visible(False)
ax4.spines["left"].set_visible(False)
ax4.spines["right"].set_visible(False)
ax4.xaxis.grid(True, alpha=0.7)
ax4.invert_yaxis()

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("box_36.pdf", bbox_inches="tight")
