# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)  # Seed for reproducibility

# Sample data representing PM2.5 levels across different times of the day in three cities
data_city1 = [
    np.random.normal(60, 15, 50),  # Morning
    np.random.normal(55, 15, 50),  # Afternoon
    np.random.normal(40, 15, 50),  # Evening
]
data_city2 = [
    np.random.normal(80, 20, 50),  # Morning
    np.random.normal(75, 20, 50),  # Afternoon
    np.random.normal(50, 20, 50),  # Evening
]
data_city3 = [
    np.random.normal(50, 10, 50),  # Morning
    np.random.normal(45, 10, 50),  # Afternoon
    np.random.normal(30, 10, 50),  # Evening
]

# Positions of the boxplots
positions_city1 = [1, 5, 9]
positions_city2 = [2, 6, 10]
positions_city3 = [3, 7, 11]
xticklabels = ["Morning", "Afternoon", "Evening"]
xticks = [2, 6, 10]
xlabel = "Time of Day"
ylabel = "PM2.5 Level (µg/m³)"
legend_labels = ["City 1", "City 2", "City 3"]
ylim = [0, 130]
legendtitle = "Cities"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axes
fig, ax = plt.subplots(figsize=(10, 6))

# Plotting the boxplots
bp_city1 = ax.boxplot(
    data_city1,
    positions=positions_city1,
    widths=1,
    patch_artist=True,
    boxprops=dict(facecolor="#3498db"),
    medianprops=dict(color="black"),
    showfliers=False,
)
bp_city2 = ax.boxplot(
    data_city2,
    positions=positions_city2,
    widths=1,
    patch_artist=True,
    boxprops=dict(facecolor="#e74c3c"),
    medianprops=dict(color="black"),
    showfliers=False,
)
bp_city3 = ax.boxplot(
    data_city3,
    positions=positions_city3,
    widths=1,
    patch_artist=True,
    boxprops=dict(facecolor="#2ecc71"),
    medianprops=dict(color="black"),
    showfliers=False,
)

# Customizing the axes
ax.set_xticks(xticks)
ax.set_xticklabels(xticklabels)
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_ylim(ylim)
ax.yaxis.grid(True, linestyle="--", linewidth=0.5)
ax.xaxis.grid(True, linestyle="--", linewidth=0.5)

# Adding legend
ax.legend(
    [bp_city1["boxes"][0], bp_city2["boxes"][0], bp_city3["boxes"][0]],
    legend_labels,
    loc="upper left",
    title=legendtitle,
)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("box_41.pdf", bbox_inches="tight")
