# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# New sample data for product sales across various quarters in three regions
sales_data_region1 = [
    np.random.normal(200, 20, 100),  # Region 1, Quarter 1
    np.random.normal(220, 25, 100),  # Region 1, Quarter 2
    np.random.normal(180, 15, 100),  # Region 1, Quarter 3
    np.random.normal(210, 30, 100),  # Region 1, Quarter 4
]
sales_data_region2 = [
    np.random.normal(300, 30, 100),  # Region 2, Quarter 1
    np.random.normal(320, 35, 100),  # Region 2, Quarter 2
    np.random.normal(280, 25, 100),  # Region 2, Quarter 3
    np.random.normal(310, 40, 100),  # Region 2, Quarter 4
]
sales_data_region3 = [
    np.random.normal(400, 25, 100),  # Region 3, Quarter 1
    np.random.normal(420, 30, 100),  # Region 3, Quarter 2
    np.random.normal(380, 20, 100),  # Region 3, Quarter 3
    np.random.normal(410, 35, 100),  # Region 3, Quarter 4
]

# Positions of the boxplots
positions_region1 = [1, 5, 9, 13]
positions_region2 = [2, 6, 10, 14]
positions_region3 = [3, 7, 11, 15]
xticklabels = ["Q1", "Q2", "Q3", "Q4"]
xticks = [2, 6, 10, 14]
xlabel = "Quarters"
ylabel = "Sales ($ in Thousands)"
legend_labels = ["Region 1", "Region 2", "Region 3"]
ylim = [100, 500]
legendtitle = "Regions"
title = "Product Sales Across Various Quarters in Different Regions"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axes
fig, ax = plt.subplots(figsize=(10, 7))

# Plotting the boxplots
bp_region1 = ax.boxplot(
    sales_data_region1,
    positions=positions_region1,
    widths=0.8,
    patch_artist=True,
    boxprops=dict(facecolor="#FF5733"),  # Nice different color
    medianprops=dict(color="blue", linewidth=2),
    showfliers=False,
)
bp_region2 = ax.boxplot(
    sales_data_region2,
    positions=positions_region2,
    widths=0.8,
    patch_artist=True,
    boxprops=dict(facecolor="#33FFC1"),  # Nice different color
    medianprops=dict(color="blue", linewidth=2),
    showfliers=False,
)
bp_region3 = ax.boxplot(
    sales_data_region3,
    positions=positions_region3,
    widths=0.8,
    patch_artist=True,
    boxprops=dict(facecolor="#338AFF"),  # Nice different color
    medianprops=dict(color="blue", linewidth=2),
    showfliers=False,
)

# Customizing the axes
ax.set_xticks(xticks)
ax.set_xticklabels(xticklabels)
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_ylim(ylim)
ax.yaxis.grid(True, linestyle="--", linewidth=0.5)
ax.xaxis.grid(True, linestyle="--", linewidth=0.5)

# Adding legend
ax.legend(
    [bp_region1["boxes"][0], bp_region2["boxes"][0], bp_region3["boxes"][0]],
    legend_labels,
    loc="upper right",
    title=legendtitle,
)

# Adding title
plt.title(title)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("box_42.pdf", bbox_inches="tight")
