# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Sample data for the domain of environmental science
data_urban = [
    np.random.normal(80, 10, 50),
    np.random.normal(90, 10, 50),
    np.random.normal(85, 10, 50),
]
data_suburban = [
    np.random.normal(40, 10, 50),
    np.random.normal(50, 10, 50),
    np.random.normal(45, 10, 50),
]
data_rural = [
    np.random.normal(20, 5, 50),
    np.random.normal(25, 5, 50),
    np.random.normal(30, 5, 50),
]

# Positions of the boxplots
positions_urban = [1, 5, 9]
positions_suburban = [2, 6, 10]
positions_rural = [3, 7, 11]
xticklabels = ["Morning", "Afternoon", "Evening"]
xticks = [2, 6, 10]
xlabel = "Time of Day"
ylabel = "AQI (Air Quality Index)"
legend_labels = ["Urban Areas", "Suburban Areas", "Rural Areas"]
ylim = [0, 120]
legendtitle = "Area Type"
title = "AQI Levels by Area Type and Time of Day"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axes
fig, ax = plt.subplots(figsize=(10, 7))

# Plotting the boxplots
bp_urban = ax.boxplot(
    data_urban,
    positions=positions_urban,
    widths=1,
    patch_artist=True,
    boxprops=dict(facecolor="#8B5A2B"),
    medianprops=dict(color="black"),
    showfliers=False,
)
bp_suburban = ax.boxplot(
    data_suburban,
    positions=positions_suburban,
    widths=1,
    patch_artist=True,
    boxprops=dict(facecolor="#228B22"),
    medianprops=dict(color="black"),
    showfliers=False,
)
bp_rural = ax.boxplot(
    data_rural,
    positions=positions_rural,
    widths=1,
    patch_artist=True,
    boxprops=dict(facecolor="#DAA520"),
    medianprops=dict(color="black"),
    showfliers=False,
)

# Customizing the axes
ax.set_xticks(xticks)
ax.set_xticklabels(xticklabels)
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_ylim(ylim)
ax.yaxis.grid(True, linestyle="--", linewidth=0.5)
ax.xaxis.grid(True, linestyle="--", linewidth=0.5)

# Adding legend
ax.legend(
    [bp_urban["boxes"][0], bp_suburban["boxes"][0], bp_rural["boxes"][0]],
    legend_labels,
    loc="upper right",
    title=legendtitle,
)

# Adding title
plt.title(title)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("box_43.pdf", bbox_inches="tight")
