
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.colors as mcolors

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Sample data for book sales across different genres
genre1_center = np.random.randint(300, 600, 9)
genre2_center = np.random.randint(500, 900, 9)
genre3_center = np.random.randint(400, 800, 9)
genre1_data = [
    np.random.normal(genre1_center[i], std, 100)
    for (i, std) in enumerate(np.random.choice(range(30, 70), 9, replace=False))
]
genre2_data = [
    np.random.normal(genre2_center[i], std, 100)
    for (i, std) in enumerate(np.random.choice(range(40, 80), 9, replace=False))
]
genre3_data = [
    np.random.normal(genre3_center[i], std, 100)
    for (i, std) in enumerate(np.random.choice(range(35, 75), 9, replace=False))
]

# Text labels
titles = ["Genre 1 Book Sales", "Genre 2 Book Sales", "Genre 3 Book Sales"]
ylabel = "Books Sold"
xticklabels = [
    "January", "February", "March", "April", "May",
    "June", "July", "August", "September"
]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and subplots
fig, axs = plt.subplots(1, 3, figsize=(25, 8))

# Create a new colormap with distinct colors
cmap = mcolors.LinearSegmentedColormap.from_list(
    "book_sales_cmap", ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728", "#9467bd", "#8c564b", "#e377c2", "#7f7f7f", "#bcbd22"]
)

# Get 9 colors from the colormap
colors = cmap(np.linspace(0, 1, 9))

# Genre 1 Book Sales subplot
bplot = axs[0].boxplot(genre1_data, patch_artist=True)
axs[0].set_title(titles[0])
axs[0].set_ylabel(ylabel)
axs[0].set_xticklabels(xticklabels, rotation=45)
for patch, color in zip(bplot["boxes"], colors):
    patch.set_facecolor(color)
    patch.set_alpha(0.7)
for median in bplot['medians']:
    median.set(color='#000000', linewidth=2)

# Genre 2 Book Sales subplot
bplot1 = axs[1].boxplot(genre2_data, patch_artist=True)
axs[1].set_title(titles[1])
axs[1].set_xticklabels(xticklabels, rotation=45)
for patch, color in zip(bplot1["boxes"], colors):
    patch.set_facecolor(color)
    patch.set_alpha(0.7)
for median in bplot1['medians']:
    median.set(color='#000000', linewidth=2)

# Genre 3 Book Sales subplot
bplot2 = axs[2].boxplot(genre3_data, patch_artist=True)
axs[2].set_title(titles[2])
axs[2].set_xticklabels(xticklabels, rotation=45)
for patch, color in zip(bplot2["boxes"], colors):
    patch.set_facecolor(color)
    patch.set_alpha(0.7)
for median in bplot2['medians']:
    median.set(color='#000000', linewidth=2)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("box_44.pdf", bbox_inches="tight")
