
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.colors as mcolors

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Generate random data representing box office revenues (in millions) for different genres in several cities
np.random.seed(42)
# Mean revenues for Action, Drama, and Comedy in millions
action_means = np.random.randint(50, 150, 9)
drama_means = np.random.randint(20, 100, 9)
comedy_means = np.random.randint(10, 70, 9)

# Generate revenue data with different standard deviations
action_data = [
    np.random.normal(action_means[i], std, 100)
    for (i, std) in enumerate(np.random.choice(range(5, 15), 9, replace=False))
]
drama_data = [
    np.random.normal(drama_means[i], std, 100)
    for (i, std) in enumerate(np.random.choice(range(5, 15), 9, replace=False))
]
comedy_data = [
    np.random.normal(comedy_means[i], std, 100)
    for (i, std) in enumerate(np.random.choice(range(5, 15), 9, replace=False))
]

# Titles and labels for the plots
titles = ["Action Movie Revenues", "Drama Movie Revenues", "Comedy Movie Revenues"]
ylabel = "Box Office Revenue (Millions)"
xticklabels = [
    "City A", "City B", "City C", "City D", "City E", 
    "City F", "City G", "City H", "City I"
]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and subplots
fig, axs = plt.subplots(1, 3, figsize=(25, 8))

# Create a colormap with environmental colors
cmap = mcolors.LinearSegmentedColormap.from_list("env_cmap", ["#2E8B57", "#3CB371", "#66CDAA", "#8FBC8F", "#228B22", "#32CD32", "#98FB98", "#8A2BE2", "#5F9EA0"])

# Get 9 colors from the colormap
colors = cmap(np.linspace(0, 1, 9))

# Action movie revenues subplot
bplot = axs[0].boxplot(action_data, patch_artist=True)
axs[0].set_title(titles[0])
axs[0].set_ylabel(ylabel)
axs[0].set_xticklabels(
    xticklabels,
    rotation=45,
)

for patch, color in zip(bplot["boxes"], colors):
    patch.set_facecolor(color)

# Drama movie revenues subplot
bplot1 = axs[1].boxplot(drama_data, patch_artist=True)
axs[1].set_title(titles[1])
axs[1].set_xticklabels(
    xticklabels,
    rotation=45,
)
for patch, color in zip(bplot1["boxes"], colors):
    patch.set_facecolor(color)

# Comedy movie revenues subplot
bplot2 = axs[2].boxplot(comedy_data, patch_artist=True)
axs[2].set_title(titles[2])
axs[2].set_xticklabels(
    xticklabels,
    rotation=45,
)
for patch, color in zip(bplot2["boxes"], colors):
    patch.set_facecolor(color)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("box_45.pdf", bbox_inches="tight")
