
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.colors as mcolors

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(0)
# Sample data for population domain
center_morning = np.random.randint(300, 400, 9)
center_afternoon = np.random.randint(200, 300, 9)
center_evening = np.random.randint(100, 200, 9)

data_morning = [
    np.random.normal(center_morning[i], std, 100)
    for (i, std) in enumerate(np.random.choice(range(20, 40), 9, replace=False))
]
data_afternoon = [
    np.random.normal(center_afternoon[i], std, 100)
    for (i, std) in enumerate(np.random.choice(range(15, 30), 9, replace=False))
]
data_evening = [
    np.random.normal(center_evening[i], std, 100)
    for (i, std) in enumerate(np.random.choice(range(10, 25), 9, replace=False))
]

titles = ["Morning Population", "Afternoon Population", "Evening Population"]
ylabel = "Number of People"
xticklabels = [
    "City A",
    "City B",
    "City C",
    "City D",
    "City E",
    "City F",
    "City G",
    "City H",
    "City I",
]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and subplots
fig, axs = plt.subplots(1, 3, figsize=(25, 8))

# Colormap for population themes
cmap_population = mcolors.LinearSegmentedColormap.from_list(
    "population_cmap", ["#2E8B57", "#4682B4", "#FFA500"]
)
# Get 9 colors from the colormap
colors = cmap_population(np.linspace(0, 1, 9))

# Morning Population subplot
bplot_morning = axs[0].boxplot(data_morning, patch_artist=True)
axs[0].set_title(titles[0])
axs[0].set_ylabel(ylabel)
axs[0].set_xticklabels(xticklabels, rotation=45, fontsize=12)

for patch, color in zip(bplot_morning["boxes"], colors):
    patch.set_facecolor(color)
    patch.set_alpha(0.6)

# Afternoon Population subplot
bplot_afternoon = axs[1].boxplot(data_afternoon, patch_artist=True)
axs[1].set_title(titles[1])
axs[1].set_xticklabels(xticklabels, rotation=45, fontsize=12)
for patch, color in zip(bplot_afternoon["boxes"], colors):
    patch.set_facecolor(color)
    patch.set_alpha(0.6)

# Evening Population subplot
bplot_evening = axs[2].boxplot(data_evening, patch_artist=True)
axs[2].set_title(titles[2])
axs[2].set_xticklabels(xticklabels, rotation=45, fontsize=12)
for patch, color in zip(bplot_evening["boxes"], colors):
    patch.set_facecolor(color)
    patch.set_alpha(0.6)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("box_46.pdf", bbox_inches="tight")
